/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.sql_like;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-no-multiple-returns", languages={ELanguage.PLSQL, ELanguage.ESQL}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidMultipleReturnsInFunctionCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            if (!"function".equals(method.getSubtype())) continue;
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        List<ShallowEntity> returnEntities = this.getReturnEntities(entity);
        if (returnEntities.isEmpty() || returnEntities.size() == 1) {
            return;
        }
        this.buildFinding("Function `" + entity.getName() + "` should not contain more than one `RETURN` statement", this.buildLocation().forEntityFirstLine(entity)).createAndStore();
    }

    private List<ShallowEntity> getReturnEntities(ShallowEntity entity) {
        ArrayList<ShallowEntity> result = new ArrayList<ShallowEntity>();
        UnmodifiableList children = entity.getChildren();
        if (children.isEmpty()) {
            return result;
        }
        for (ShallowEntity child : children) {
            if (child.getSubtype().equals("return")) {
                result.add(child);
                continue;
            }
            result.addAll(this.getReturnEntities(child));
        }
        return result;
    }
}

