/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.sql_like;

import eu.cqse.check.cs.NoParameterModifierBase;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.collections.UnmodifiableList;

public abstract class AvoidUsingInOutParameterBase
extends NoParameterModifierBase {
    protected AvoidUsingInOutParameterBase() {
        super(ETokenType.INOUT);
    }

    @Override
    protected void processEntity(ShallowEntity method) throws CheckException {
        List<IToken> inOutParameters = this.getModifiedTokens(method);
        UnmodifiableList methodBody = method.getChildren();
        this.processInOutParameter(inOutParameters, (List<ShallowEntity>)methodBody);
    }

    private void processInOutParameter(List<IToken> inOutParameters, List<ShallowEntity> methodBody) {
        List<IToken> methodBodyTokens = methodBody.stream().map(ShallowEntity::includedTokens).flatMap(Collection::stream).toList();
        Map<String, ParameterWithReadWriteInfo> parametersWithReadWriteInfo = this.getReadWriteInfoForParameters(inOutParameters, methodBodyTokens);
        for (ParameterWithReadWriteInfo inOutParameter : parametersWithReadWriteInfo.values()) {
            this.checkParameterUsage(inOutParameter);
        }
    }

    protected abstract void checkParameterUsage(ParameterWithReadWriteInfo var1);

    private Map<String, ParameterWithReadWriteInfo> getReadWriteInfoForParameters(List<IToken> parameters, List<IToken> methodBody) {
        HashMap<String, IToken> parameterNames = new HashMap<String, IToken>();
        parameters.forEach(parameter -> parameterNames.put(parameter.getText(), (IToken)parameter));
        HashMap<String, ParameterWithReadWriteInfo> parameterInfo = new HashMap<String, ParameterWithReadWriteInfo>();
        parameterNames.forEach((parameterName, parameterNameToken) -> parameterInfo.put((String)parameterName, new ParameterWithReadWriteInfo((IToken)parameterNameToken)));
        List parameterIndexes = TokenStreamUtils.findAll(methodBody, (ITokenMatcher)ETokenType.IDENTIFIER);
        for (Integer parameterIndex : parameterIndexes) {
            this.setReadWriteInfo(methodBody, parameterIndex, parameterNames, parameterInfo);
        }
        return parameterInfo;
    }

    private void setReadWriteInfo(List<IToken> methodBody, Integer parameterIndex, Map<String, IToken> parameterNames, Map<String, ParameterWithReadWriteInfo> parameterInfo) {
        IToken identifier = methodBody.get(parameterIndex);
        if (parameterNames.containsKey(identifier.getText())) {
            if (this.isAssignment(methodBody, parameterIndex)) {
                parameterInfo.get(identifier.getText()).setWritten(true);
            } else {
                parameterInfo.get(identifier.getText()).setRead(true);
            }
        }
    }

    private boolean isAssignment(List<IToken> tokens, Integer index) {
        if (tokens.size() <= index + 1) {
            return false;
        }
        return switch (this.language) {
            case ELanguage.PLSQL -> AvoidUsingInOutParameterBase.isPlsqlAssigment(tokens, index);
            case ELanguage.ESQL -> AvoidUsingInOutParameterBase.isEsqlAssigment(tokens, index);
            default -> false;
        };
    }

    private static boolean isPlsqlAssigment(List<IToken> tokens, Integer index) {
        if (tokens.get(index + 1).getType() == ETokenType.ASSIGNMENT) {
            return true;
        }
        if (tokens.size() > index + 3 && tokens.get(index + 1).getType() == ETokenType.DOT && tokens.get(index + 3).getType() == ETokenType.ASSIGNMENT) {
            return true;
        }
        if (index == 0) {
            return false;
        }
        return tokens.get(index - 1).getType() == ETokenType.INTO;
    }

    private static boolean isEsqlAssigment(List<IToken> tokens, Integer index) {
        if (index == 0) {
            return false;
        }
        return tokens.get(index - 1).getType() == ETokenType.SET && tokens.get(index + 1).getType() == ETokenType.EQ;
    }

    protected void createFinding(IToken parameter, String tokenType) {
        String message = String.format("`IN OUT` parameter `%s` only used as `%s` parameter", parameter.getText(), tokenType);
        this.buildFinding(message, this.buildLocation().forToken(parameter)).createAndStore();
    }

    protected static class ParameterWithReadWriteInfo {
        private final IToken parameterToken;
        private boolean read = false;
        private boolean written = false;

        ParameterWithReadWriteInfo(IToken parameterToken) {
            this.parameterToken = parameterToken;
        }

        public void setRead(boolean read) {
            this.read = read;
        }

        public void setWritten(boolean written) {
            this.written = written;
        }

        public IToken getParameterToken() {
            return this.parameterToken;
        }

        public boolean isRead() {
            return this.read;
        }

        public boolean isWritten() {
            return this.written;
        }
    }
}

