/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.sql_like;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.tokens.MatchGroupElement;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-unused-vars-sql-like", languages={ELanguage.ESQL, ELanguage.PLSQL, ELanguage.TSQL}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class NoUnusedVariableCheck
extends CheckImplementationBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int PARAMETER_NAME_GROUP_INDEX = 0;
    private static final TokenPattern METHOD_DECLARATION_PATTERN = new TokenPattern().sequence(new Object[]{Set.of(ETokenType.LPAREN, ETokenType.COMMA)}).optional(new Object[]{Set.of(ETokenType.IN, ETokenType.OUT, ETokenType.INOUT)}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0);

    public void execute() throws CheckException {
        this.checkBlock(this.context.getRootEntity(this.getCodeViewOption()), new HashSet<Variable>());
    }

    private void checkBlock(ShallowEntity block, Set<Variable> declaredVars) {
        HashSet<Variable> currentVariableDeclarations = new HashSet();
        if (EShallowEntityType.METHOD == block.getType()) {
            currentVariableDeclarations = this.findParameterDeclarations(block);
            this.updateShadowLevel(currentVariableDeclarations, declaredVars, true);
        }
        for (ShallowEntity entity : block.getChildren()) {
            this.checkEntity(entity, currentVariableDeclarations, declaredVars);
        }
        this.checkVariableIsUnused(currentVariableDeclarations);
    }

    private Set<Variable> findParameterDeclarations(ShallowEntity block) {
        HashSet<Variable> parameterDeclarations = new HashSet<Variable>();
        METHOD_DECLARATION_PATTERN.findAll((List)block.ownStartTokens()).stream().map(match -> ((MatchGroupElement)match.getMatchGroup(0).get(0)).getTokens()).forEach(parameter -> parameterDeclarations.add(new Variable((IToken)parameter.get(0))));
        return parameterDeclarations;
    }

    private void checkEntity(ShallowEntity entity, Set<Variable> currentVariableDeclarations, Set<Variable> declaredVars) {
        HashSet<Variable> combinedVariableDeclarations = new HashSet<Variable>(declaredVars);
        combinedVariableDeclarations.addAll(currentVariableDeclarations);
        this.checkEntityForUsage(combinedVariableDeclarations, entity);
        if (EShallowEntityType.ATTRIBUTE == entity.getType() || this.isPlsqlExceptionDeclaration(entity)) {
            Variable variable = this.extractVariable(entity);
            if (ETokenType.COLUMN == variable.getToken().getType()) {
                return;
            }
            currentVariableDeclarations.add(variable);
            combinedVariableDeclarations.add(variable);
            this.updateShadowLevel(Set.of(variable), declaredVars, true);
            if (!entity.hasChildren()) {
                return;
            }
        }
        this.checkBlock(entity, combinedVariableDeclarations);
        this.updateShadowLevel(currentVariableDeclarations, declaredVars, false);
    }

    private Variable extractVariable(ShallowEntity attributeDeclaration) {
        UnmodifiableList includedTokens = attributeDeclaration.includedTokens();
        if (this.isPlsqlCursor(attributeDeclaration)) {
            return new Variable((IToken)includedTokens.get(1));
        }
        return new Variable((IToken)includedTokens.get(0));
    }

    private boolean isPlsqlCursor(ShallowEntity entity) {
        return this.context.getLanguage() == ELanguage.PLSQL && "cursor".equals(entity.getSubtype()) && entity.includedTokens().size() > 1;
    }

    private boolean isPlsqlExceptionDeclaration(ShallowEntity entity) {
        return this.context.getLanguage() == ELanguage.PLSQL && EShallowEntityType.META == entity.getType() && "exception declaration".equals(entity.getSubtype());
    }

    private void checkVariableIsUnused(Set<Variable> currentVariableDeclarations) {
        for (Variable currentVariable : currentVariableDeclarations) {
            if (currentVariable.isUsed()) continue;
            this.createFinding(currentVariable);
        }
    }

    private void checkEntityForUsage(HashSet<Variable> combinedVariableDeclarations, ShallowEntity entity) {
        Object tokensToCheck = entity.ownStartTokens();
        if (this.context.getLanguage() == ELanguage.PLSQL && this.isPragmaExceptionInit((List<IToken>)tokensToCheck)) {
            return;
        }
        if (this.isPlsqlExceptionDeclaration(entity)) {
            return;
        }
        if (EShallowEntityType.ATTRIBUTE == entity.getType()) {
            tokensToCheck = this.getTokensToCheckInVariableDeclarations(entity, (List<IToken>)tokensToCheck);
        }
        for (Variable variable : combinedVariableDeclarations) {
            if (variable.isShadowed() || !tokensToCheck.stream().anyMatch(token -> token.getText().equals(variable.getToken().getText()))) continue;
            variable.setUsed();
        }
    }

    private List<IToken> getTokensToCheckInVariableDeclarations(ShallowEntity entity, List<IToken> tokensToCheck) {
        if (tokensToCheck == null || tokensToCheck.isEmpty()) {
            return new ArrayList<IToken>();
        }
        if (this.isPlsqlCursor(entity)) {
            return tokensToCheck.subList(2, tokensToCheck.size() - 1);
        }
        return tokensToCheck.subList(1, tokensToCheck.size() - 1);
    }

    private boolean isPragmaExceptionInit(List<IToken> tokens) {
        if (tokens.size() < 8) {
            return false;
        }
        return tokens.get(0).getType() == ETokenType.PRAGMA && tokens.get(1).getType() == ETokenType.EXCEPTION_INIT;
    }

    private void createFinding(Variable variable) {
        this.buildFinding("Unused variable " + variable.getToken().getText(), this.buildLocation().forToken(variable.getToken())).createAndStore();
    }

    private void updateShadowLevel(Set<Variable> newVariables, Set<Variable> declaredVariables, boolean increase) {
        Set newVariableNames = newVariables.stream().map(Variable::getName).collect(Collectors.toSet());
        for (Variable variable : declaredVariables) {
            if (!newVariableNames.contains(variable.getName())) continue;
            if (increase) {
                variable.addShadowLevel();
                continue;
            }
            variable.reduceShadowLevel();
        }
    }

    private static class Variable {
        private final IToken token;
        private boolean used = false;
        private int shadowLevel = 0;

        public Variable(IToken token) {
            this.token = token;
        }

        public IToken getToken() {
            return this.token;
        }

        public void setUsed() {
            this.used = true;
        }

        public boolean isUsed() {
            return this.used;
        }

        public boolean isShadowed() {
            return this.shadowLevel != 0;
        }

        public String getName() {
            return this.token.getText();
        }

        public void addShadowLevel() {
            ++this.shadowLevel;
        }

        public void reduceShadowLevel() {
            if (this.shadowLevel > 0) {
                --this.shadowLevel;
                return;
            }
            LOGGER.warn("Shadow level for variable " + this.getName() + "(line " + this.token.getLineNumber() + ") is already 0 but tries to get reduced. This might indicate a bug in the check.");
        }
    }
}

