/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.sqlscript.sqlstatement;

import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.sqlscript.sqlstatement.SqlStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SqlQuery {
    private final SqlStatement statement;
    private final int beginTokenIndex;
    private final int endTokenIndex;
    private final List<SqlQuery> subqueries = new ArrayList<SqlQuery>();
    private final int nestingLevel;
    private int ownMaximumNestingDepth = 0;

    SqlQuery(SqlStatement statement) {
        this(statement, 0, statement.getTokens().size() - 1, 0);
    }

    private SqlQuery(SqlQuery parent, int beginTokenIndex, int endTokenIndex) {
        this(parent.statement, beginTokenIndex, endTokenIndex, parent.nestingLevel + 1);
    }

    private SqlQuery(SqlStatement statement, int beginTokenIndex, int endTokenIndex, int nestingLevel) {
        this.statement = statement;
        this.beginTokenIndex = beginTokenIndex;
        this.endTokenIndex = endTokenIndex;
        this.nestingLevel = nestingLevel;
        this.initializeSubqueries();
    }

    private void initializeSubqueries() {
        int searchIndex = this.beginTokenIndex + 1;
        while (searchIndex <= this.endTokenIndex) {
            int subqueryBegin = this.findSubqueryBegin(searchIndex);
            if (subqueryBegin == -1) {
                return;
            }
            int subqueryEnd = this.findSubqueryEnd(subqueryBegin);
            searchIndex = subqueryEnd + 1;
            while (this.statement.getToken(subqueryBegin).getType() == ETokenType.LPAREN) {
                ++subqueryBegin;
            }
            if (this.statement.getToken(subqueryBegin).getType() != ETokenType.SELECT) continue;
            while (this.statement.getToken(subqueryEnd).getType() == ETokenType.RPAREN) {
                --subqueryEnd;
            }
            SqlQuery subquery = new SqlQuery(this, subqueryBegin, subqueryEnd);
            if (subquery.ownMaximumNestingDepth >= this.ownMaximumNestingDepth) {
                this.ownMaximumNestingDepth = subquery.ownMaximumNestingDepth + 1;
            }
            this.subqueries.add(subquery);
        }
    }

    private int findSubqueryBegin(int startTokenIndex) {
        return TokenStreamUtils.firstTokenMatching(this.statement.getTokens(), (int)startTokenIndex, (int)(this.endTokenIndex + 1), (ITokenMatcher)ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.SELECT, ETokenType.LPAREN}));
    }

    public IToken getBeginToken() {
        return this.statement.getToken(this.beginTokenIndex);
    }

    public IToken getEndToken() {
        return this.statement.getToken(this.endTokenIndex);
    }

    private int findSubqueryEnd(int subQueryBeginTokenIndex) {
        if (this.statement.getTokens().get(subQueryBeginTokenIndex).getType() == ETokenType.LPAREN) {
            return TokenStreamUtils.findMatchingClosingToken(this.statement.getTokens(), (int)(subQueryBeginTokenIndex + 1), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        }
        return this.endTokenIndex;
    }

    public boolean hasSubquery() {
        return !this.subqueries.isEmpty();
    }

    public int getMaximumNestingDepth() {
        return this.ownMaximumNestingDepth + this.nestingLevel;
    }

    void collectSubqueriesDeeperThan(int threshold, List<SqlQuery> result) {
        if (this.nestingLevel > threshold) {
            result.add(this);
            return;
        }
        for (SqlQuery subquery : this.subqueries) {
            subquery.collectSubqueriesDeeperThan(threshold, result);
        }
    }

    public List<SqlQuery> getSubqueries() {
        return this.subqueries;
    }

    public boolean containsAnyToken(Set<ETokenType> tokenTypes) {
        return TokenStreamUtils.containsAny(this.statement.getTokens(), (int)this.beginTokenIndex, (int)(this.endTokenIndex + 1), tokenTypes);
    }
}

