/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.wia;

import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.WorkItemDescriberBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckFindingBuilderBase;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.wia.KeywordCheckUtils;
import eu.cqse.check.wia.WorkItemCheckBase;
import eu.cqse.check.wia.parsable.rule.ParsableRule;
import eu.cqse.check.wia.parsable.rule.TypedSetRule;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import org.conqat.engine.commons.findings.location.ElementLocation;

@Check(id="cqse-wia-no-loopholes-or-escape-clauses", languages={ELanguage.NL_REQUIREMENTS, ELanguage.NL_TESTS})
public class LoopholeCheck
extends WorkItemCheckBase<SpecItem> {
    private static final String CHECK_NAME = "No Loophole";
    @CheckOption(name="No Loophole - Rules", description="The list of rules that specify for which *item types* and which *item fields* this check is executed.\nMultiple rules are separated by new-lines.\n<p>\nA rule has the format:\n\n`<itemTypes> -> <fieldNames>`\n\n`<itemTypes>`: a `|` separated list of item types.<br>\nThis check is executed for all listed types.\nA type must be specified as full name (e.g., `Requirement`)\tor its abbreviation (e.g., `REQ`).\nThe special placeholder `ANY` can be used in place of a concrete type list to execute this check irrespective of the item types.\n\n`<fieldNames>`: a `|` separated list of item fields.<br>\nThis check is executed on all listed fields that are present in any of the item types of the same rule.\nThe special placeholder `ALL` can be used in place of a concrete field list to execute this check on all fields.\n\nHere are some example rules:\n+ `Requirement -> Description`<br>\n  The check is executed on the `Description` field of `Requirement` items.\n+ `REQ | WI -> Description | Status`<br>\n  The check is executed on the `Description` and `Status` fields of `REQ` and `WI` items.\n+ `ANY -> Description`<br>\n  The check is executed on the `Description` field of all items irrespective of their types.\n+ `REQ -> ALL`<br>\n  The check is executed on all fields of `REQ` items.\n+ `ANY -> ALL`<br>\n  The check is executed on all fields all items irrespective of their types.\n", multilineText=true)
    private Set<String> rawLoopholeRules = Collections.emptySet();
    @CheckOption(name="No Loophole - Text ignore patterns (regex)", description="A list of comma separated Java regex patterns for text parts that are ignored and\nnot included in the detection of this check.\nFor example, the regex `\".*?\"` ignores text that is enclosed in double quotes.\n")
    private List<String> ignorePatterns = List.of("\".*?\"", "(?<=\\W|^)'.*?'");
    @CheckOption(name="No Loophole - Loophole Terms", description="A set of loophole terms that the check will look for.\n")
    private Set<String> loopholeTerms = Set.of("as applicable", "as appropriate", "as little as possible", "as much as possible", "as required", "ideally", "if it should prove practicable.", "if possible", "if practicable", "maximize", "minimize", "normally", "optimize", "optionally", "reasonable", "so far as is possible", "to the extent necessary", "to the extent practical", "to the extent that", "when necessary", "where appropriate", "where possible");
    private static final String MESSAGE_PREFIX = "Prefer clear, definitive, and measurable language to avoid loopholes";
    private final Set<TypedSetRule<String>> parsedLoopholeRules = new HashSet<TypedSetRule<String>>();
    private static final TypedSetRule.Parser<String> PARSER = new TypedSetRule.Parser<String>().withValueParser(ParsableRule.RuleParser.TO_STRING);

    public LoopholeCheck() {
        super(SpecItem.class);
    }

    public void initialize() throws CheckException {
        super.initialize();
        for (String rawRule : this.rawLoopholeRules) {
            this.parsedLoopholeRules.add((TypedSetRule<String>)PARSER.parse(rawRule));
        }
    }

    @Override
    protected void execute(SpecItem item) throws CheckException {
        WorkItemDescriberBase describer = this.getDescriber((TeamscaleIssue)item);
        LoopholeCheck loopholeCheck = this;
        BiFunction<String, Optional<? extends ElementLocation>, CheckFindingBuilderBase> function = (x$0, x$1) -> loopholeCheck.buildFinding((String)x$0, (Optional)x$1);
        KeywordCheckUtils.executeKeywordSetCheck(item, MESSAGE_PREFIX, function, describer, this.parsedLoopholeRules, this.loopholeTerms, this.buildLocation(), this.ignorePatterns);
    }
}

