/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.wia;

import com.teamscale.wia.ETextValueMode;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.WorkItemDescriberBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.wia.WorkItemCheckBase;
import eu.cqse.check.wia.parsable.rule.ParsableRule;
import eu.cqse.check.wia.parsable.rule.TypedMultiMapRule;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.string.SimpleNLPUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jspecify.annotations.NonNull;

@Check(id="cqse-wia-max-sentence-length", languages={ELanguage.NL_TESTS, ELanguage.NL_REQUIREMENTS})
public class MaxSentenceLengthCheck
extends WorkItemCheckBase<SpecItem> {
    private static final String CHECK_NAME = "Max Word Count Per Sentence";
    @CheckOption(name="Max Word Count Per Sentence - Rules", description="List of sentence length rules separated by new-line.\n\nA single sentence length rule has the format:\n\n`<itemTypes> -> <maxSentenceLengths>`\n\n`<itemTypes>` is a `|` separated list of item types (e.g., `Requirement`, `Test Case`, `Manual Test Case`, etc.) or their abbreviations (e.g., `REG`, `TC`, `MTC`, etc.)\n\n<maxSentenceLengths> is a `|` or '+' separated list of field rules, where each field rule has the format <field1>[|<field2>]*:<maxSentenceLength>, mapping field names to integers representing the maximum sentence length allowed in each field.\n\n`ANY` is a keyword that matches any `ItemType`.\n\n`ALL` is a keyword that matches all fields of an item.\n\nHere are some example rules:\n\n`Requirement -> Description:20 + Acceptance Criteria:15` implies that the item of type `Requirement` must not contain sentences longer than `20` words in `Description` and `15` words in `Acceptance Criteria`.\n\n`Requirement -> Description | Acceptance Criteria:20` implies that the item of type `Requirement` must not contain sentences longer than `20` words in `Description` or `Acceptance Criteria` fields.\n\n`Test Case|Requirement -> Test Step:100 + Fail State:120` implies items of the types `Test Case` or `Requirement` must not contain sentences longer than `10` words in `Test Step` and `12` words in `Fail State`.\n\n`Requirement|Test Case -> description | additionalInfo : 40 + subject:10` implies that for items of type `Requirement` or `Test Case`, the `description` and 'additionalInfo' field must not contain sentences longer than 40 words, and the `subject` field of these items must not contain sentences longer than 10 words as well.\n\n`ANY -> Description:20` implies that any item type must not contain sentences longer than `20` words in `Description`.\n\n`ANY -> ALL:25` implies that any item type must not contain sentences longer than `25` words in any field.\n", multilineText=true)
    private Set<String> rawMaxSentenceRules = Collections.emptySet();
    private final Set<TypedMultiMapRule<String, Integer>> parsedMaxSentenceLengthRules = new HashSet<TypedMultiMapRule<String, Integer>>();
    private static final TypedMultiMapRule.Parser<String, Integer> PARSER = new TypedMultiMapRule.Parser().withKeyParser(ParsableRule.RuleParser.TO_STRING).withValueParser(ParsableRule.RuleParser.TO_INTEGER);

    public MaxSentenceLengthCheck() {
        super(SpecItem.class);
    }

    public void initialize() throws CheckException {
        super.initialize();
        for (String rawRule : this.rawMaxSentenceRules) {
            this.parsedMaxSentenceLengthRules.add((TypedMultiMapRule<String, Integer>)PARSER.parse(rawRule));
        }
    }

    @Override
    protected void execute(SpecItem item) throws CheckException {
        for (TypedMultiMapRule<String, Integer> rule : this.parsedMaxSentenceLengthRules) {
            if (!rule.matches(item)) continue;
            if (rule.map.containsKey("ALL")) {
                int value = (Integer)rule.map.get("ALL");
                for (String field : this.getDescriber((TeamscaleIssue)item).getNonTechnicalKeys((TeamscaleIssue)item)) {
                    this.checkViolation(item, field, value);
                }
                continue;
            }
            for (Map.Entry entry : rule.map.entrySet()) {
                this.checkViolation(item, (String)entry.getKey(), (Integer)entry.getValue());
            }
        }
    }

    private void checkViolation(SpecItem item, String field, int maxSentenceLength) {
        WorkItemDescriberBase.IValueDescriber valueDescriber = this.getDescriber((TeamscaleIssue)item).getValueDescriber(field);
        String fieldText = valueDescriber.getValue((TeamscaleIssue)item, ETextValueMode.WITH_HTML_TAGS_REMOVED);
        if (StringUtils.isEmpty((String)fieldText)) {
            return;
        }
        List sentenceDetails = SimpleNLPUtils.splitIntoSentences((String)fieldText);
        for (SimpleNLPUtils.SentenceDetails sentenceDetail : sentenceDetails) {
            int numOfWordsInSentence = SimpleNLPUtils.splitIntoWords((String)sentenceDetail.getSentence()).size();
            if (numOfWordsInSentence <= maxSentenceLength) continue;
            String rawFieldValue = StringUtils.emptyIfNull((String)valueDescriber.getValue((TeamscaleIssue)item, ETextValueMode.RAW));
            this.buildFinding(MaxSentenceLengthCheck.buildFindingMessage(maxSentenceLength, numOfWordsInSentence), this.buildLocation().forAttribute(valueDescriber.getExactKeyName((TeamscaleIssue)item), rawFieldValue)).addFindingProperties(MaxSentenceLengthCheck.buildProperties(item, field, numOfWordsInSentence - maxSentenceLength)).createAndStore();
        }
    }

    private static @NonNull FindingPropertyList buildProperties(SpecItem specItem, String violatedField, int exceededWords) {
        FindingPropertyList properties = new FindingPropertyList();
        properties.addProperty("Item Type", (Object)specItem.getHumanReadableType());
        properties.addProperty("Item Field", (Object)violatedField);
        properties.addProperty("Exceeded Words", (Object)exceededWords);
        return properties;
    }

    static String buildFindingMessage(int maxSentenceLength, int numOfWordsInSentence) {
        return String.format("Violation of sentence length threshold (number of words) of %d: %d", maxSentenceLength, numOfWordsInSentence);
    }
}

