/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.wia.parsable.rule;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.wia.parsable.rule.ParsableRule;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.function.FunctionWithException;

public class TypedMultiMapRule<K, V>
extends ParsableRule {
    public final Map<K, V> map;

    private TypedMultiMapRule(Set<String> itemTypes, Map<K, V> map) {
        super(itemTypes);
        this.map = map;
    }

    public static class Parser<K, V>
    extends ParsableRule.RuleParser {
        private FunctionWithException<String, K, CheckException> keyParser;
        private FunctionWithException<String, V, CheckException> valueParser;

        public Parser<K, V> withKeyParser(FunctionWithException<String, K, CheckException> keyParser) {
            this.keyParser = keyParser;
            return this;
        }

        public Parser<K, V> withValueParser(FunctionWithException<String, V, CheckException> valueParser) {
            this.valueParser = valueParser;
            return this;
        }

        @Override
        public TypedMultiMapRule<K, V> parse(String rule) throws CheckException {
            Pair<String, String> assignment = Parser.parseAssignment(rule);
            List<String> rawKeyValueList = Parser.parseLinkedListPlus((String)assignment.getSecond());
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (String rawKeyValue : rawKeyValueList) {
                Pair<String, String> keyValue = Parser.parseKeyValue(rawKeyValue);
                Set<String> keySet = Parser.parseSet((String)keyValue.getFirst());
                Object value = this.valueParser.apply((Object)((String)keyValue.getSecond()));
                for (String rawKey : keySet) {
                    Object key = this.keyParser.apply((Object)rawKey);
                    if (map.containsKey(key)) {
                        throw new CheckException("Duplicate definition of key \"%s\" in rule \"%s\". First value: \"%s\" Second value: \"%s\"".formatted(key, rawKeyValueList, map.get(key), value));
                    }
                    map.put(key, value);
                }
            }
            if (map.isEmpty()) {
                throw new CheckException("Unable to parse multi map \"%s\", has to contain at least one element".formatted(assignment.getSecond()));
            }
            return new TypedMultiMapRule(Parser.parseSet((String)assignment.getFirst()), map);
        }
    }
}

