/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.xml;

import eu.cqse.check.xml.XmlCheckBase;
import eu.cqse.check.xml.XmlCheckHandlerBase;
import eu.cqse.check.xml.XmlElementAttributesCheckHandlerBase;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.xml.sax.Attributes;

public abstract class AttributeRegexCheckBase
extends XmlCheckBase {
    private final String parentXmlElementName;
    private final Set<String> xmlElementNames;
    private final String xmlAttributeName;
    private final boolean isFindingIfMatches;

    private AttributeRegexCheckBase(String parentXmlElementName, Set<String> xmlElementNames, String xmlAttributeName, boolean isFindingIfMatches) {
        this.parentXmlElementName = parentXmlElementName;
        this.xmlElementNames = xmlElementNames;
        this.xmlAttributeName = xmlAttributeName;
        this.isFindingIfMatches = isFindingIfMatches;
    }

    private AttributeRegexCheckBase(String parentXmlElementName, String xmlElementName, String xmlAttributeName, boolean isFindingIfMatches) {
        this(parentXmlElementName, Collections.singleton(xmlElementName), xmlAttributeName, isFindingIfMatches);
    }

    public AttributeRegexCheckBase(String parentXmlElemntName, String xmlElementName, String xmlAttributeName) {
        this(parentXmlElemntName, xmlElementName, xmlAttributeName, false);
    }

    public AttributeRegexCheckBase(Set<String> xmlElementNames, String xmlAttributeName, boolean isFindingIfMatches) {
        this(null, xmlElementNames, xmlAttributeName, isFindingIfMatches);
    }

    public AttributeRegexCheckBase(Set<String> xmlElementNames, String xmlAttributeName) {
        this(null, xmlElementNames, xmlAttributeName, false);
    }

    protected static Pattern getPrefixPattern(String prefix) {
        return Pattern.compile("^" + Pattern.quote(prefix) + ".*");
    }

    protected abstract String getFindingsMessage();

    protected abstract Pattern getPattern();

    protected boolean ignore(Attributes attributes) {
        return false;
    }

    @Override
    public XmlCheckHandlerBase getHandler() {
        return new XmlElementAttributesCheckHandlerBase(this, this.parentXmlElementName, this.xmlElementNames){
            final /* synthetic */ AttributeRegexCheckBase this$0;
            {
                AttributeRegexCheckBase attributeRegexCheckBase = this$0;
                Objects.requireNonNull(attributeRegexCheckBase);
                this.this$0 = attributeRegexCheckBase;
                super(parentXmlElementName, xmlElementNames);
            }

            @Override
            protected void checkAttributes(Attributes attributes) {
                if (this.this$0.ignore(attributes)) {
                    return;
                }
                String attributeValue = attributes.getValue(this.this$0.xmlAttributeName);
                if (attributeValue == null) {
                    return;
                }
                Pattern pattern = this.this$0.getPattern();
                boolean matches = pattern.matcher(attributeValue).matches();
                if (matches == this.this$0.isFindingIfMatches) {
                    this.createFinding(attributeValue, pattern);
                }
            }

            private void createFinding(String attributeValue, Pattern pattern) {
                attributeValue = MarkupUtils.formatAsSourceCode((String)attributeValue);
                StringBuilder message = new StringBuilder(this.this$0.getFindingsMessage()).append(" (").append(attributeValue);
                if (this.this$0.isFindingIfMatches) {
                    message.append(" matches");
                } else {
                    message.append(" does not match");
                }
                if (this.this$0.showPatternInFindingsMessage()) {
                    message.append(" pattern ").append(MarkupUtils.formatAsSourceCode((String)pattern.toString()));
                }
                message.append(")");
                this.createFinding(message.toString());
            }
        };
    }

    protected boolean showPatternInFindingsMessage() {
        return true;
    }
}

