/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.xml;

import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.xml.XmlCheckHandlerBase;
import java.io.IOException;
import java.util.Set;
import org.conqat.lib.commons.xml.XMLUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XmlCheckBase
extends CheckImplementationBase {
    public void execute() throws CheckException {
        this.preProcess();
        XmlCheckHandlerBase handler = this.getHandler();
        try {
            XMLUtils.parseSAX((InputSource)XMLUtils.toInputSource((String)this.context.getTextContent(ECodeViewOption.ETextViewOption.FILTERED_CONTENT)), (DefaultHandler)handler);
        }
        catch (IOException | SAXException e) {
            throw new CheckException("Unable to parse " + this.context.getUniformPath(), e);
        }
        this.copyFindingsToContext(handler.getFindings());
    }

    private void copyFindingsToContext(Set<XmlCheckHandlerBase.XmlFinding> xmlFindings) throws CheckException {
        for (XmlCheckHandlerBase.XmlFinding xmlFinding : xmlFindings) {
            int line = xmlFinding.getLine();
            if (line == -1) {
                this.buildFinding(xmlFinding.getMessage(), this.buildLocation().forElement()).createAndStore();
                continue;
            }
            this.buildFinding(xmlFinding.getMessage(), this.buildLocation().forLine(line)).createAndStore();
        }
    }

    public abstract XmlCheckHandlerBase getHandler();

    protected void preProcess() throws CheckException {
    }
}

