/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.matlab.mat.format;

import java.io.EOFException;
import java.io.IOException;
import us.hebi.matlab.mat.format.Mat5Reader;
import us.hebi.matlab.mat.format.Mat5Type;
import us.hebi.matlab.mat.types.Source;

public class Mat5Tag {
    private final Mat5Type type;
    private final int numBytes;
    private final boolean packed;
    private final Source source;

    public Mat5Type getType() {
        return this.type;
    }

    public int getNumBytes() {
        return this.numBytes;
    }

    public int getNumElements() {
        return this.numBytes / this.type.bytes();
    }

    public int getPadding() {
        return this.type.getPadding(this.numBytes, this.packed);
    }

    public static Mat5Tag readTagOrNull(Source source) throws IOException {
        try {
            return Mat5Tag.readTag(source);
        }
        catch (EOFException eof) {
            return null;
        }
    }

    public static Mat5Tag readTag(Source source) throws IOException {
        int numBytes;
        Mat5Type type;
        boolean packed;
        int tmp = source.readInt();
        boolean bl = packed = tmp >> 16 != 0;
        if (!packed) {
            type = Mat5Type.fromId(tmp);
            numBytes = source.readInt();
        } else {
            numBytes = tmp >> 16;
            type = Mat5Type.fromId(tmp & 0xFFFF);
        }
        if (numBytes % type.bytes() != 0) {
            throw Mat5Reader.readError("Found invalid number of bytes for tag '%s'. Expected multiple of %d. Found %d", new Object[]{type, type.bytes(), numBytes});
        }
        return new Mat5Tag(type, numBytes, packed, source);
    }

    byte[] readAsBytes() throws IOException {
        byte[] buffer = new byte[this.getNumBytes()];
        this.source.readBytes(buffer, 0, buffer.length);
        this.source.skip(this.getPadding());
        return buffer;
    }

    short[] readAsShorts() throws IOException {
        this.checkMultipleOf(2, "short[]");
        short[] buffer = new short[this.getNumBytes() / 2];
        this.source.readShorts(buffer, 0, buffer.length);
        this.source.skip(this.getPadding());
        return buffer;
    }

    int[] readAsInts() throws IOException {
        this.checkMultipleOf(4, "int[]");
        int[] buffer = new int[this.getNumBytes() / 4];
        this.source.readInts(buffer, 0, buffer.length);
        this.source.skip(this.getPadding());
        return buffer;
    }

    long[] readAsLongs() throws IOException {
        this.checkMultipleOf(8, "long[]");
        long[] buffer = new long[this.getNumBytes() / 8];
        this.source.readLongs(buffer, 0, buffer.length);
        this.source.skip(this.getPadding());
        return buffer;
    }

    float[] readAsFloats() throws IOException {
        this.checkMultipleOf(4, "float[]");
        float[] buffer = new float[this.getNumBytes() / 4];
        this.source.readFloats(buffer, 0, buffer.length);
        this.source.skip(this.getPadding());
        return buffer;
    }

    double[] readAsDoubles() throws IOException {
        this.checkMultipleOf(8, "double[]");
        double[] buffer = new double[this.getNumBytes() / 8];
        this.source.readDoubles(buffer, 0, buffer.length);
        this.source.skip(this.getPadding());
        return buffer;
    }

    private void checkMultipleOf(int bytes, String target) throws IOException {
        if (this.getNumBytes() % bytes != 0) {
            throw Mat5Reader.readError("Tag with %d bytes cannot be read as %s", bytes, target);
        }
    }

    public String toString() {
        return "Mat5Tag{type=" + (Object)((Object)this.type) + ", numBytes=" + this.numBytes + (this.packed ? " (packed)" : "") + '}';
    }

    private Mat5Tag(Mat5Type type, int numBytes, boolean packed, Source source) {
        this.type = type;
        this.numBytes = numBytes;
        this.packed = packed;
        this.source = source;
    }
}

