/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.configuration.AnalysisProfileValidationResult;
import com.teamscale.index.configuration.ConnectorValidationResult;
import com.teamscale.index.migration.code_scopes.ProjectConfiguration71To98;
import com.teamscale.index.migration.v88_project_alias.V89ProjectConfigurationUnmigrated;
import com.teamscale.index.migration.v88_project_alias.V89ProjectInfoUnmigrated;
import com.teamscale.service.framework.NoProjectStorageSystem;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;

public interface IProjectServiceApi {
    @GET
    @RequiresNoPermission(description="Only projects visible to the user are returned in the get all queries.")
    @Operation(summary="Get projects", tags={"Project"}, description="Returns a list of all projects.")
    @PublicApi(since=ETeamscaleVersion.VERSION_7_1_0)
    public List<ProjectInfo> getAllProjects(@QueryParam(value="include-deleting") @Parameter(description="Whether to include projects marked as deleted or not.") boolean var1, @QueryParam(value="include-reanalyzing") @Parameter(description="Whether to include reanalyzing projects or not.") boolean var2) throws StorageException;

    @GET
    @RequiresNoPermission(description="Only projects visible to the user are returned in the get all queries.")
    @Operation(summary="Get projects", tags={"Project"}, description="Returns a list of all projects.")
    @PublicApi(since=ETeamscaleVersion.VERSION_5_2_0, deprecatedSince=ETeamscaleVersion.VERSION_7_1_0)
    public List<V89ProjectInfoUnmigrated> getAllProjectsLegacy(@QueryParam(value="include-deleting") @Parameter(description="Whether to include projects marked as deleted or not.") boolean var1, @QueryParam(value="include-reanalyzing") @Parameter(description="Whether to include reanalyzing projects or not.") boolean var2) throws StorageException;

    @GET
    @Path(value="aliases")
    @RequiresNoPermission(description="Only projects visible to the user are returned in the get all queries.")
    @Operation(summary="Get project aliases", tags={"Project"}, description="Returns all projects by their primary aliases (if set) or id.")
    @PublicApi(since=ETeamscaleVersion.VERSION_5_2_0, deprecatedSince=ETeamscaleVersion.VERSION_7_1_0)
    public String[] getAllProjectAliasesOrIds(@QueryParam(value="include-deleting") @Parameter(description="Whether to include projects marked as deleted or not.") boolean var1, @QueryParam(value="include-reanalyzing") @Parameter(description="Whether to include reanalyzing projects or not.") boolean var2) throws StorageException;

    @GET
    @Path(value="ids")
    @RequiresNoPermission(description="Only projects visible to the user are returned in the get all queries.")
    @Operation(summary="Get project IDs", tags={"Project"}, description="Returns all primary project IDs.")
    @PublicApi(since=ETeamscaleVersion.VERSION_7_1_0)
    public List<String> getAllProjectIds(@QueryParam(value="include-deleting") @Parameter(description="Whether to include projects marked as deleted or not.") boolean var1, @QueryParam(value="include-reanalyzing") @Parameter(description="Whether to include reanalyzing projects or not.") boolean var2) throws StorageException;

    @GET
    @Path(value="{project}")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get project", tags={"Project"}, description="Returns details on a project.")
    @PublicApi(since=ETeamscaleVersion.VERSION_7_1_0)
    public ProjectInfo getProject(@PathParam(value="project") IProjectId var1) throws StorageException;

    @GET
    @Path(value="{project}")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get project", tags={"Project"}, description="Returns details on a project.")
    @PublicApi(since=ETeamscaleVersion.VERSION_5_2_0, deprecatedSince=ETeamscaleVersion.VERSION_7_1_0)
    public V89ProjectInfoUnmigrated getProjectLegacy(@PathParam(value="project") PublicProjectId var1) throws StorageException;

    @PUT
    @Path(value="{project}")
    @RequiresProjectPermission(value={EProjectPermission.EDIT})
    @Operation(summary="Update project", tags={"Project"}, description="Updates an existing project.", responses={@ApiResponse(responseCode="400", description="Invalid alias supplied or resource ID does not match supplied ProjectInfo")})
    @PublicApi(since=ETeamscaleVersion.VERSION_7_1_0)
    public ProjectUpdateResult editProject(@PathParam(value="project") InternalProjectId var1, @RequestBody ProjectInfo var2) throws StorageException;

    @PUT
    @Path(value="{project}")
    @RequiresProjectPermission(value={EProjectPermission.EDIT})
    @Operation(summary="Update project", tags={"Project"}, description="Updates an existing project.", responses={@ApiResponse(responseCode="400", description="Invalid alias supplied or resource ID does not match supplied ProjectInfo")})
    @PublicApi(since=ETeamscaleVersion.VERSION_5_2_0, deprecatedSince=ETeamscaleVersion.VERSION_7_1_0)
    public ProjectUpdateResult editProjectLegacy(@PathParam(value="project") PublicProjectId var1, @RequestBody V89ProjectInfoUnmigrated var2) throws StorageException;

    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_PROJECTS})
    @Operation(summary="Create project", description="Creates project based on provided project configuration.", tags={"Project"}, responses={@ApiResponse(responseCode="201", description="Project created based on provided configuration."), @ApiResponse(responseCode="400", description="Project validation error occurred.", content={@Content(mediaType="application/json", schema=@Schema(oneOf={AnalysisProfileValidationResult.class, ConnectorValidationResult.class}))})})
    @PublicApi(since=ETeamscaleVersion.VERSION_9_9_0)
    public Response createProject(@RequestBody ProjectConfiguration var1, @Parameter(description="Indicates whether to copy all data (ext. uploads, finding exclusions, etc.) from an existing project. The value is the project id.") @QueryParam(value="copy-data-from-project") PublicProjectId var2, @Parameter(description="Indicates whether to skip validation of the project. Can be used to force project creation despite validation errors.") @QueryParam(value="skip-project-validation") boolean var3) throws StorageException;

    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_PROJECTS})
    @Operation(summary="Create project", description="Creates project based on provided project configuration.", tags={"Project"}, responses={@ApiResponse(responseCode="201", description="Project created based on provided configuration."), @ApiResponse(responseCode="400", description="Project validation error occurred.")})
    @PublicApi(since=ETeamscaleVersion.VERSION_5_6_0, deprecatedSince=ETeamscaleVersion.VERSION_7_1_0)
    public Response createProjectLegacy56To70(@RequestBody V89ProjectConfigurationUnmigrated var1, @Parameter(description="Indicates whether to copy all data (ext. uploads, finding exclusions, etc.) from an existing project. The value is the project id.") @QueryParam(value="copy-data-from-project") PublicProjectId var2, @Parameter(description="Indicates whether to skip validation of the project. Can be used to force project creation despite validation errors.") @QueryParam(value="skip-project-validation") boolean var3) throws StorageException;

    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_PROJECTS})
    @Operation(summary="Create project", description="Creates project based on provided project configuration.", tags={"Project"}, responses={@ApiResponse(responseCode="201", description="Project created based on provided configuration."), @ApiResponse(responseCode="400", description="Project validation error occurred.")})
    @PublicApi(since=ETeamscaleVersion.VERSION_7_1_0, deprecatedSince=ETeamscaleVersion.VERSION_9_9_0)
    public Response createProjectLegacyTeamscale71To98(@RequestBody ProjectConfiguration71To98 var1, @Parameter(description="Indicates whether to copy all data (ext. uploads, finding exclusions, etc.) from an existing project. The value is the project id.") @QueryParam(value="copy-data-from-project") PublicProjectId var2, @Parameter(description="Indicates whether to skip validation of the project. Can be used to force project creation despite validation errors.") @QueryParam(value="skip-project-validation") boolean var3) throws StorageException;

    @DELETE
    @Path(value="{project}")
    @Operation(summary="Delete project", tags={"Project"}, description="Deletes a project.")
    @RequiresProjectPermission(value={EProjectPermission.DELETE})
    @NoProjectStorageSystem
    @PublicApi(since=ETeamscaleVersion.VERSION_5_2_0)
    public void deleteProject(@PathParam(value="project") IProjectId var1, @Parameter(description="Whether to force project deletion regardless of current deletion or re-analysis state.") @QueryParam(value="force-delete") boolean var2, @Parameter(description="Whether all current role assignments should be deleted. Otherwise these can be reimported if a project with the same id or alias is created.") @QueryParam(value="delete-all-assignments") boolean var3, @Parameter(description="Whether dashboards that only refer to the project to delete or/and non-existing projects should be deleted.") @QueryParam(value="delete-all-dashboards") boolean var4, @Parameter(description="Whether to remove child project references that target this project as parent.") @QueryParam(value="delete-child-references") boolean var5) throws StorageException, NotAuthorizedException;

    @POST
    @Path(value="{project}/visited")
    @Operation(summary="Register project visit", tags={"Project"}, description="Notifies the server that the user visited a project. This is used to display information about the most recently visited projects in the project selector.")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public void registerProjectViewedByUser() throws StorageException;

    public static class ProjectUpdateResult {
        @JsonProperty(value="reAnalysisIsRequired")
        private final boolean reAnalysisIsRequired;
        @JsonProperty(value="message")
        private final String message;

        @JsonCreator
        public ProjectUpdateResult(@JsonProperty(value="message") String message, @JsonProperty(value="reAnalysisIsRequired") boolean reAnalysisIsRequired) {
            this.reAnalysisIsRequired = reAnalysisIsRequired;
            this.message = message;
        }
    }
}

