/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin;

import com.fasterxml.jackson.databind.JsonNode;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreator;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.log.AuditLogs;
import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.TeamscaleVersionContainer;
import com.teamscale.core.permissions.PermissionModifier;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.runtime.impl.project.CopyProjectDataTrigger;
import com.teamscale.core.runtime.impl.project.DeleteProjectTrigger;
import com.teamscale.core.runtime.impl.scheduling.ProjectSchedulingFilter;
import com.teamscale.core.utils.ProjectUtils;
import com.teamscale.index.backup.EBackupStatus;
import com.teamscale.index.backup.TemporaryFileIndex;
import com.teamscale.index.backup.read.BackupImportOptions;
import com.teamscale.index.backup.read.BackupImportStatus;
import com.teamscale.index.backup.read.BackupReader;
import com.teamscale.index.backup.read.BackupReadingParameters;
import com.teamscale.index.configuration.AnalysisProfileValidationResult;
import com.teamscale.index.configuration.ConnectorValidationResult;
import com.teamscale.index.configuration.service.EProjectConfigurationVersion;
import com.teamscale.index.dashboard.DashboardDescriptor;
import com.teamscale.index.dashboard.DashboardIndex;
import com.teamscale.index.dashboard.DashboardUtils;
import com.teamscale.index.dashboard.ProjectDashboardsMappingIndex;
import com.teamscale.index.migration.ProjectVersion44CodeScopeMigration;
import com.teamscale.index.migration.code_scopes.ProjectConfiguration71To98;
import com.teamscale.index.migration.v88_project_alias.V89ProjectConfigurationMigrated;
import com.teamscale.index.migration.v88_project_alias.V89ProjectConfigurationUnmigrated;
import com.teamscale.index.migration.v88_project_alias.V89ProjectInfoMigrated;
import com.teamscale.index.migration.v88_project_alias.V89ProjectInfoUnmigrated;
import com.teamscale.index.user.UserRecentlyViewedProjectsIndex;
import com.teamscale.service.admin.IProjectServiceApi;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.logging.ICriticalEventLogger;
import com.teamscale.service.project.ProjectServiceUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.core.logging.LoggingEventTransport;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectIdBase;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.filesystem.ZipFile;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.jspecify.annotations.NonNull;

@Path(value="api/projects")
public class ProjectService
extends ApiBase
implements IProjectServiceApi {
    @Context
    private ICriticalEventLogger criticalEventLogger;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String PROJECT_CREATION_BLACKLIST_PROPERTY_NAME = "com.teamscale.project-creation-blacklist";
    private static final String PROJECT_BLACKLIST_REGEX = System.getProperty("com.teamscale.project-creation-blacklist");

    @Override
    public List<V89ProjectInfoUnmigrated> getAllProjectsLegacy(boolean includeDeleting, boolean includeReanalyzing) throws StorageException {
        List<ProjectInfo> allProjects = this.getAllProjects(includeDeleting, includeReanalyzing);
        List projectsJson = CollectionUtils.map(allProjects, JsonUtils::serializeToJSON);
        try {
            List migratedInfos = CollectionUtils.mapWithException((Collection)projectsJson, json -> (V89ProjectInfoMigrated)JsonUtils.deserializeFromJson((String)json, V89ProjectInfoMigrated.class));
            return CollectionUtils.map((Collection)migratedInfos, V89ProjectInfoUnmigrated::new);
        }
        catch (JsonSerializationException e) {
            throw new StorageException((Throwable)e);
        }
    }

    @Override
    public List<ProjectInfo> getAllProjects(boolean includeDeleting, boolean includeReanalyzing) throws StorageException {
        return this.getPermissions().getVisibleProjects(includeDeleting, includeReanalyzing);
    }

    @Override
    public String[] getAllProjectAliasesOrIds(boolean includeDeleting, boolean includeReanalyzing) throws StorageException {
        return (String[])CollectionUtils.toArray(this.getAllProjectIds(includeDeleting, includeReanalyzing), String.class);
    }

    @Override
    public List<String> getAllProjectIds(boolean includeDeleting, boolean includeReanalyzing) throws StorageException {
        return CollectionUtils.map((Collection)ProjectUtils.resolveToPrimaryPublicId((List)this.getPermissions().getVisibleProjects(includeDeleting, includeReanalyzing)), ProjectIdBase::toString);
    }

    @Override
    public ProjectInfo getProject(IProjectId projectId) throws StorageException {
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        return projectIndex.tryResolveProject(projectId).orElse(null);
    }

    @Override
    public V89ProjectInfoUnmigrated getProjectLegacy(PublicProjectId projectId) throws StorageException {
        ProjectInfo project = this.getProject((IProjectId)projectId);
        try {
            return new V89ProjectInfoUnmigrated((V89ProjectInfoMigrated)JsonUtils.deserializeFromJson((String)JsonUtils.serializeToJSON((Object)project), V89ProjectInfoMigrated.class));
        }
        catch (JsonSerializationException e) {
            throw new StorageException((Throwable)e);
        }
    }

    @Override
    public void deleteProject(IProjectId projectId, boolean forceDelete, boolean deleteAllAssignments, boolean deleteAllDashboards, boolean deleteChildReferences) throws StorageException {
        ProjectInfo projectToDelete = this.getProject(projectId);
        if (projectToDelete.isDeletingOrReanalyzing() && !forceDelete) {
            throw new NotFoundException("Cannot delete project " + String.valueOf(projectId) + " which is being deleted/reanalyzed!");
        }
        if (deleteAllAssignments) {
            this.deleteAllProjectRoleAssignments(projectToDelete);
        }
        if (deleteAllDashboards) {
            this.deleteProjectDashboards(projectToDelete);
        }
        if (deleteChildReferences) {
            this.deleteChildProjectReferences(projectToDelete.getInternalId());
        }
        projectToDelete.setDeleting(true);
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        projectIndex.setProject(projectToDelete);
        this.resumeProjectIfPaused((IProjectId)projectToDelete.getInternalId(), projectIndex);
        if (forceDelete && !this.projectStorageSystemExists(projectId)) {
            LOGGER.error("Project storage system for project " + String.valueOf(projectId) + " does not exist, which indicates a previous incomplete deletion. Please check previous errors. Project will be deleted completely now.");
            projectIndex.removeProject(projectToDelete.getInternalId());
            this.serviceInfo.getIndexLayer().getStorageCacheProvider().invalidateCaches();
        } else {
            this.scheduleProjectDeletionJob(projectId, projectToDelete);
        }
        this.criticalEventLogger.logCriticalEventMessage((IProjectId)SchedulingConstants.MAINTENANCE_PROJECT_INTERNAL_ID, "Project deletion event: " + String.valueOf(projectId));
        AuditLogs.projectDeleted((String)projectToDelete.getPrimaryPublicId().projectId);
    }

    private void deleteChildProjectReferences(InternalProjectId projectId) throws StorageException {
        this.openGlobalIndex(ProjectIndex.class).getAllProjectInfos().stream().filter(info -> info.getParentProjectId().filter(parentId -> parentId.equals((Object)projectId)).isPresent()).forEach(childInfo -> childInfo.setParentProjectId(null));
    }

    private void resumeProjectIfPaused(IProjectId projectId, ProjectIndex projectIndex) throws StorageException {
        Optional internalProjectId = projectIndex.tryResolveToInternalId(projectId);
        if (internalProjectId.isPresent()) {
            ProjectSchedulingFilter.resumeProjectIfPaused((InternalProjectId)((InternalProjectId)internalProjectId.get()), (GlobalStorageSystem)this.serviceInfo.getGlobalStorageSystem());
        }
    }

    private void scheduleProjectDeletionJob(IProjectId projectId, ProjectInfo projectToDelete) throws StorageException {
        JobDescriptor deletionJob = JobDescriptor.forProject((InternalProjectId)projectToDelete.getInternalId()).withPrivilegedTrigger(DeleteProjectTrigger.class).withSchedulingReason("Deletion of project " + String.valueOf(projectId) + " by user.").build();
        ISchedulerCommunicator.getInstance().scheduleExternalJob(this.getIndexLayer(), deletionJob);
    }

    private void deleteAllProjectRoleAssignments(ProjectInfo projectToDelete) throws StorageException, NotAuthorizedException {
        PermissionModifier permissionModifier = this.getPermissions().createPermissionModifier();
        permissionModifier.removeAllProjectRoleAssignments(projectToDelete);
    }

    private boolean projectStorageSystemExists(IProjectId projectId) {
        try {
            this.getProjectStorageSystem(projectId);
            return true;
        }
        catch (StorageException e) {
            return false;
        }
    }

    private void deleteProjectDashboards(ProjectInfo projectToDelete) throws StorageException {
        ProjectDashboardsMappingIndex dashboardsMappingIndex = this.openGlobalIndex(ProjectDashboardsMappingIndex.class);
        DashboardIndex dashboardIndex = this.openGlobalIndex(DashboardIndex.class);
        List allDashboards = dashboardIndex.getAllDashboards();
        HashSet<PublicProjectId> projectIds = new HashSet<PublicProjectId>((Collection<PublicProjectId>)projectToDelete.getPublicIds());
        for (DashboardDescriptor dashboardDescriptor : allDashboards) {
            ArrayList<PublicProjectId> projectsReferencedInDashboard = new ArrayList<PublicProjectId>(DashboardUtils.extractProjectIdsFromDashboard((JsonNode)dashboardDescriptor.getDescriptor()));
            if (!ProjectService.isDashboardToDelete(projectsReferencedInDashboard, projectIds)) continue;
            DashboardUtils.removeDashboardFromIndexes((UUID)dashboardDescriptor.getId(), (DashboardIndex)dashboardIndex, (ProjectDashboardsMappingIndex)dashboardsMappingIndex);
        }
    }

    private static boolean isDashboardToDelete(List<PublicProjectId> projectsReferencedInDashboard, Set<PublicProjectId> projectId) {
        HashSet otherProjectsReferencedByDashboard = CollectionUtils.differenceSet(projectsReferencedInDashboard, (Collection[])new Collection[]{projectId});
        return !projectsReferencedInDashboard.isEmpty() && otherProjectsReferencedByDashboard.isEmpty();
    }

    @Override
    public IProjectServiceApi.ProjectUpdateResult editProject(InternalProjectId projectId, ProjectInfo newProjectInfo) throws StorageException {
        ProjectInfo oldProjectInfo = this.getProject((IProjectId)projectId);
        if (!oldProjectInfo.getInternalId().equals((Object)newProjectInfo.getInternalId())) {
            throw new BadRequestException("This may not change the project's ID.");
        }
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        UnmodifiableList newPublicIds = newProjectInfo.getPublicIds();
        ProjectService.checkValidPublicIds(projectIndex, newProjectInfo.getInternalId(), (List<PublicProjectId>)newPublicIds);
        newProjectInfo.setCreationTimestamp(oldProjectInfo.getCreationTimestamp());
        projectIndex.setProject(newProjectInfo);
        if (!oldProjectInfo.getPrimaryPublicId().equals((Object)newProjectInfo.getPrimaryPublicId())) {
            PermissionModifier permissionModifier = this.getPermissions().createPermissionModifier();
            permissionModifier.removeCurrentUserAsProjectAdmin(oldProjectInfo);
            permissionModifier.makeCurrentUserProjectAdmin(newProjectInfo);
        }
        this.updateProjectConfiguration(newProjectInfo);
        return new IProjectServiceApi.ProjectUpdateResult("success", true);
    }

    @Override
    public IProjectServiceApi.ProjectUpdateResult editProjectLegacy(PublicProjectId projectId, V89ProjectInfoUnmigrated newProjectInfo) throws StorageException {
        ProjectIndex projectIndex = (ProjectIndex)this.getGlobalStorageSystem().openGlobalIndex(ProjectIndex.class);
        return this.editProject(projectIndex.resolveToInternalId((IProjectId)projectId), this.migrateProjectInfoToTeamscale71(newProjectInfo));
    }

    @Override
    public Response createProject(ProjectConfiguration projectConfiguration, PublicProjectId projectToCopyDataFrom, boolean skipProjectValidation) throws StorageException {
        if (!StringUtils.isEmpty((String)PROJECT_BLACKLIST_REGEX) && projectConfiguration.getPublicIds().stream().anyMatch(id -> id.toString().matches(PROJECT_BLACKLIST_REGEX.trim().toLowerCase()))) {
            return Response.status((int)304, (String)"Project creation rejected due to configuration settings").build();
        }
        if (projectConfiguration.getBranchingConfiguration() == null) {
            projectConfiguration.setDefaultBranchingConfiguration();
        }
        ProjectIndex projectIndex = (ProjectIndex)this.getGlobalStorageSystem().openGlobalIndex(ProjectIndex.class);
        ProjectServiceUtils.validateIdentifiers(projectConfiguration);
        ProjectCreator projectCreator = new ProjectCreator(this.getIndexLayer(), this.getUser().getUsername(), ConfigurationInitializationContext.EInitializationReason.PROJECT_CREATION);
        Response projectCreateResult = this.getProjectCreateResult(projectConfiguration, projectCreator, projectIndex, projectToCopyDataFrom, skipProjectValidation);
        this.criticalEventLogger.logCriticalEventMessage((IProjectId)SchedulingConstants.MAINTENANCE_PROJECT_INTERNAL_ID, "Project creation event: " + String.valueOf(projectConfiguration.getPrimaryPublicId()));
        this.criticalEventLogger.logCriticalEventMessage((IProjectId)projectConfiguration.getInternalId(), "Project creation event");
        AuditLogs.createdProject((String)projectConfiguration.getPrimaryPublicId().projectId);
        return projectCreateResult;
    }

    @Override
    public Response createProjectLegacyTeamscale71To98(ProjectConfiguration71To98 projectConfiguration, PublicProjectId projectToCopyDataFrom, boolean skipProjectValidation) throws StorageException {
        return this.createProject(ProjectService.migrateProjectConfigToTeamscale99(projectConfiguration), projectToCopyDataFrom, skipProjectValidation);
    }

    @Override
    public Response createProjectLegacy56To70(V89ProjectConfigurationUnmigrated projectConfiguration, PublicProjectId projectToCopyDataFrom, boolean skipProjectValidation) throws StorageException {
        return this.createProjectLegacyTeamscale71To98(ProjectService.migrateProjectConfigToTeamscale71(projectConfiguration), projectToCopyDataFrom, skipProjectValidation);
    }

    @Override
    public void registerProjectViewedByUser() throws StorageException {
        UserRecentlyViewedProjectsIndex userLastViewedBranchesIndex = this.openGlobalIndex(UserRecentlyViewedProjectsIndex.class);
        userLastViewedBranchesIndex.registerProjectViewed(this.getUser().getUsername(), this.serviceInfo.getPrimaryPublicId());
    }

    @POST
    @Path(value="import")
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_PROJECTS})
    @Operation(summary="Import project(s)", description="Imports a project(s) into the instance. The given file can either be a project configuration (.tsproject) or a project backup (.zip).", tags={"Project"})
    @Consumes(value={"multipart/form-data"})
    public void importProjectConfiguration(@Parameter(required=true, array=@ArraySchema(schema=@Schema(type="string", format="binary"))) @FormDataParam(value="project-configuration") List<FormDataBodyPart> configurations) throws IOException, StorageException {
        for (FormDataBodyPart configuration : configurations) {
            try (BufferedInputStream stream = new BufferedInputStream((InputStream)configuration.getEntityAs(InputStream.class));){
                ((InputStream)stream).mark(10);
                byte[] header = new byte[4];
                FileSystemUtils.safeRead((InputStream)stream, (byte[])header);
                ((InputStream)stream).reset();
                if (ByteArrayUtils.startsWithZipMagicBytes((byte[])header)) {
                    this.importFromBackupFile(stream);
                    continue;
                }
                this.importFromConfigJson(FileSystemUtils.readStreamBinary((InputStream)stream));
            }
            catch (IOException e) {
                throw new InternalServerErrorException("Failed to process multipart data!", (Throwable)e);
            }
        }
    }

    private void importFromBackupFile(InputStream inputStream) throws StorageException {
        BackupImportStatus backupResult;
        BackupReadingParameters parameters = new BackupReadingParameters(new BackupImportOptions(), this.getIndexLayer(), FileSystemUtils.getTmpDir(), this.serviceInfo.getLockProvider(), this.serviceInfo.getServerConfiguration().toInstanceConfiguration());
        try (ZipFile backupFile = this.getBackupFile(inputStream);){
            backupResult = BackupReader.importBackupData((ZipFile)backupFile, (BackupReadingParameters)parameters, (ICancelable)ICancelable.neverCanceled(), (IParallelTaskExecutor)this.getParallelTaskExecutor());
        }
        catch (IOException e) {
            throw new StorageException("Unable to load backup file", (Throwable)e);
        }
        ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
        for (PublicProjectId project : backupResult.getImportedProjects()) {
            ProjectInfo projectInfo = projectIndex.resolveProject((IProjectId)project);
            this.getPermissions().createPermissionModifier().makeCurrentUserProjectAdmin(projectInfo);
            this.criticalEventLogger.logCriticalEventMessage((IProjectId)project, "Project import event");
        }
        ProjectService.handleImportFailure(backupResult);
    }

    private @NonNull ZipFile getBackupFile(InputStream inputStream) throws StorageException {
        TemporaryFileIndex temporaryFileIndex = this.openGlobalIndex(TemporaryFileIndex.class);
        String temporaryFileName = temporaryFileIndex.getTemporaryFileName();
        try (InputStream inputStream2 = inputStream;
             OutputStream outputStream = temporaryFileIndex.writeFile(temporaryFileName);){
            FileSystemUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new StorageException("Unable to write backup to temporary file index", (Throwable)e);
        }
        try {
            return new ZipFile(temporaryFileIndex.openReadChannel(temporaryFileName), temporaryFileName);
        }
        catch (IOException e) {
            throw new StorageException("Unable to read backup from temporary file index", (Throwable)e);
        }
    }

    private static void handleImportFailure(BackupImportStatus status) {
        for (BackupImportStatus.ImportProgress progress : status.getProjectProgress()) {
            if (progress.getStatus() != EBackupStatus.FAILURE) continue;
            throw new BadRequestException(ProjectService.buildStatusMessage("Project " + String.valueOf(progress.getProject()) + ": " + progress.getStatusMessage(), progress.getLogs()));
        }
        if (status.getStatus() == EBackupStatus.FAILURE) {
            throw new BadRequestException(ProjectService.buildStatusMessage(status.getStatusMessage(), status.getLogs()));
        }
    }

    private static String buildStatusMessage(String message, List<LoggingEventTransport> logs) {
        StringBuilder messageBuilder = new StringBuilder(message);
        for (LoggingEventTransport log : logs) {
            messageBuilder.append("\n").append(log.getLevel()).append(": ").append(log.getMessage());
        }
        return messageBuilder.toString();
    }

    private void importFromConfigJson(byte[] data) throws StorageException {
        try {
            ProjectConfiguration projectConfiguration = (ProjectConfiguration)TeamscaleVersionContainer.fromJson((byte[])data, null, ProjectConfiguration.class, (Enum)EProjectConfigurationVersion.CURRENT_VERSION, (String)"project configuration");
            new ProjectCreator(this.getIndexLayer(), this.getUser().getUsername(), ConfigurationInitializationContext.EInitializationReason.PROJECT_CREATION).createProject(projectConfiguration);
            ProjectInfo projectInfo = (ProjectInfo)this.openGlobalIndex(ProjectIndex.class).getProjectWithoutPublicIdResolution(projectConfiguration.getInternalId()).orElseThrow();
            this.getPermissions().createPermissionModifier().makeCurrentUserProjectAdmin(projectInfo);
            this.criticalEventLogger.logCriticalEventMessage((IProjectId)projectInfo.getInternalId(), "Project import event");
        }
        catch (ProjectConfigurationException | MigrationException | TriggerCompilationException e) {
            throw new InternalServerErrorException("Error creating project: " + e.getMessage(), e);
        }
    }

    private static @NonNull ProjectConfiguration71To98 migrateProjectConfigToTeamscale71(V89ProjectConfigurationUnmigrated projectConfiguration) throws StorageException {
        try {
            return (ProjectConfiguration71To98)JsonUtils.deserializeFromJson((String)JsonUtils.serializeToJSON((Object)new V89ProjectConfigurationMigrated(projectConfiguration)), ProjectConfiguration71To98.class);
        }
        catch (JsonSerializationException e) {
            throw new StorageException((Throwable)e);
        }
    }

    private @NonNull ProjectInfo migrateProjectInfoToTeamscale71(V89ProjectInfoUnmigrated projectInfo) throws StorageException {
        ProjectIndex projectIndex = (ProjectIndex)this.getGlobalStorageSystem().openGlobalIndex(ProjectIndex.class);
        try {
            return (ProjectInfo)JsonUtils.deserializeFromJson((String)JsonUtils.serializeToJSON((Object)new V89ProjectInfoMigrated(projectInfo, projectIndex)), ProjectInfo.class);
        }
        catch (JsonSerializationException e) {
            throw new StorageException((Throwable)e);
        }
    }

    private static @NonNull ProjectConfiguration migrateProjectConfigToTeamscale99(ProjectConfiguration71To98 projectConfiguration) throws StorageException {
        try {
            String projectConfigurationJson = JsonUtils.serializeToJSON((Object)projectConfiguration);
            String migratedProjectConfigurationJson = ProjectVersion44CodeScopeMigration.migrate((String)projectConfigurationJson);
            return (ProjectConfiguration)JsonUtils.deserializeFromJson((String)migratedProjectConfigurationJson, ProjectConfiguration.class);
        }
        catch (JsonSerializationException e) {
            throw new StorageException((Throwable)e);
        }
    }

    private Response getProjectCreateResult(ProjectConfiguration projectConfiguration, ProjectCreator projectCreator, ProjectIndex projectIndex, PublicProjectId projectToCopyDataFrom, boolean skipProjectValidation) throws BadRequestException, StorageException {
        Lock lock = this.serviceInfo.getLockProvider().obtainLock("getProjectCreateResultLock-" + projectConfiguration.getName());
        try {
            lock.lock();
            if (!skipProjectValidation) {
                projectConfiguration.validate(this.getIndexLayer(), this.getUser().getUsername(), !StringUtils.isEmpty((String)projectConfiguration.getExternalStorageBackend()));
            }
            boolean copyDataFromExistingProject = projectToCopyDataFrom != null;
            projectCreator.createProject(projectConfiguration, !skipProjectValidation, !copyDataFromExistingProject, !skipProjectValidation);
            ProjectInfo projectInfo = (ProjectInfo)this.openGlobalIndex(ProjectIndex.class).getProjectWithoutPublicIdResolution(projectConfiguration.getInternalId()).orElseThrow();
            PermissionModifier permissionModifier = this.getPermissions().createPermissionModifier();
            permissionModifier.makeCurrentUserProjectAdmin(projectInfo);
            if (copyDataFromExistingProject) {
                this.copyDataFromProject(projectToCopyDataFrom, projectConfiguration.getInternalId(), projectIndex);
            }
            Response response = Response.created((URI)URI.create("api/projects/" + String.valueOf(projectConfiguration.getInternalId()))).build();
            return response;
        }
        catch (TriggerCompilationException e) {
            LOGGER.error("Error during project creation.", (Throwable)e);
            throw new BadRequestException(e.getMessage(), Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build());
        }
        catch (ProjectConfigurationException e) {
            LOGGER.error("Error during project creation.", (Throwable)e);
            Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
            if (e.getCodeScopeViolations() != null) {
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)AnalysisProfileValidationResult.from((ProjectConfigurationException)e)).build();
            } else if (e.getConnectorIndex() != null) {
                response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ConnectorValidationResult.from((ProjectConfigurationException)e, (int)e.getConnectorIndex())).build();
            }
            throw new BadRequestException(e.getMessage(), response);
        }
        finally {
            lock.unlock();
        }
    }

    private void copyDataFromProject(PublicProjectId fromProjectId, InternalProjectId newProjectId, ProjectIndex projectIndex) throws StorageException, BadRequestException {
        ProjectInfo oldProject = projectIndex.resolveProject((IProjectId)fromProjectId);
        ProjectInfo newProject = (ProjectInfo)projectIndex.getProjectWithoutPublicIdResolution(newProjectId).orElseThrow();
        newProject.setCopyingData(true);
        projectIndex.setProject(newProject);
        this.pauseProject(newProject.getInternalId());
        ISchedulerCommunicator.getInstance().sendReloadCommand(this.serviceInfo.getIndexLayer().getMessageBroker(), newProjectId);
        JobDescriptor copyDataJob = JobDescriptor.forProject((InternalProjectId)oldProject.getInternalId()).withPrivilegedTrigger(CopyProjectDataTrigger.class).withSchedulingReason("Copy project data from " + String.valueOf(oldProject.getPrimaryPublicId()) + " to " + String.valueOf(newProject.getPrimaryPublicId())).withParameter(newProject.getInternalId().toString()).build();
        ISchedulerCommunicator.getInstance().scheduleExternalJob(this.getIndexLayer(), copyDataJob);
    }

    private void pauseProject(InternalProjectId newProject) throws StorageException {
        ProjectSchedulingFilter.pauseProject((InternalProjectId)newProject, (GlobalStorageSystem)this.serviceInfo.getGlobalStorageSystem());
    }

    private void updateProjectConfiguration(ProjectInfo projectInfo) throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = this.serviceInfo.getProjectStorageSystem(projectInfo);
        MetaIndex projectMetaIndex = (MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null);
        ProjectConfiguration projectConfiguration = (ProjectConfiguration)projectMetaIndex.getValue(ProjectConfiguration.class);
        projectConfiguration.setName(projectInfo.getName());
        projectConfiguration.setPublicIds((List)projectInfo.getPublicIds());
        projectMetaIndex.setValue((MetaIndex.IMetaIndexEntry)projectConfiguration, ProjectConfiguration.class);
    }

    private static void checkValidPublicIds(ProjectIndex projectIndex, InternalProjectId internalProjectId, List<PublicProjectId> publicProjectIds) throws StorageException {
        if (publicProjectIds.isEmpty()) {
            throw new BadRequestException("At least one project ID must be provided.");
        }
        for (PublicProjectId publicProjectId : publicProjectIds) {
            if (PublicProjectId.isValidId((PublicProjectId)publicProjectId)) continue;
            throw new BadRequestException("The ID " + String.valueOf(publicProjectId) + " contains invalid characters! Allowed characters are -_.a-zA-Z0-9");
        }
        for (ProjectInfo projectInfo : projectIndex.getAllProjectInfos()) {
            HashSet publicIdIntersectionSet = CollectionUtils.intersectionSet(publicProjectIds, (Collection[])new Collection[]{projectInfo.getPublicIds()});
            if (projectInfo.isDeleting() || projectInfo.getInternalId().equals((Object)internalProjectId) || publicIdIntersectionSet.isEmpty()) continue;
            throw new BadRequestException("One or more projects of the same name(s) %s already exist. You need to rename or remove said projects, before adding this one.".formatted(publicIdIntersectionSet));
        }
    }
}

