/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin.backup;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.backup.BackupStatusBase;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import java.util.Optional;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.persistence.store.StorageException;

public abstract class BackupStatusServiceBase<T extends BackupStatusBase>
extends ApiBase {
    protected final String backupId;

    protected BackupStatusServiceBase(String backupId) {
        this.backupId = backupId;
    }

    @GET
    @Path(value="status")
    @RequiresNoPermission(description="The user needs to be able to configure projects. In addition the user needs to have the permission to backup global data provided the backup contains any global data and the permission to backup project data for all projects contained in the backup.")
    @PublicApi(since=ETeamscaleVersion.VERSION_6_1_0)
    public T getBackupStatus() throws StorageException {
        if (!this.getPermissions().mayConfigureProjects()) {
            throw new ForbiddenException("User can't configure projects");
        }
        T summary = this.getStatusSummary(this.backupId);
        if (summary == null) {
            throw new NotFoundException("No summary found for backup: " + this.backupId);
        }
        Optional singleProjectId = summary.getSingleProjectId();
        if (singleProjectId.isPresent()) {
            this.getPermissions().checkProjectPermission((IProjectId)singleProjectId.get(), EProjectPermission.BACKUP_DATA);
        } else {
            this.getPermissions().checkBackupAccess();
        }
        return summary;
    }

    protected abstract T getStatusSummary(String var1) throws StorageException;
}

