/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.repository.ProjectRepositoryChangeIndex;
import com.teamscale.service.admin.ServerRenderedPageServiceBase;
import com.teamscale.service.admin.debug.ForceRollbackService;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.logging.ICriticalEventLogger;
import com.teamscale.service.repository.BranchesInfo;
import com.teamscale.service.repository.ProjectBranchesService;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/admin/debug/force-rollback-all-branches")
public class ForceRollbackAllBranchesService
extends ServerRenderedPageServiceBase {
    @Context
    private ICriticalEventLogger criticalEventLogger;

    @GET
    @Hidden
    @Operation(summary="Perform rollback", description="Provides an UI to force a rollback to a given commit on all branches. This should only be used for debugging and recovery operations.", tags={"Project"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"text/html"})
    public String getForceRollbackAllBranchesPage() {
        return this.buildHttpFormPage();
    }

    @POST
    @Operation(summary="Perform rollback", description="This service allows to force a rollback to a given commit on all branches. This should only be used for debugging and recovery operations. For manual operations, use the UI provided by the GET request.", tags={"Project"})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public void forceRollbackAllBranches(@FormParam(value="commit") UnresolvedCommitDescriptor commitDescriptor) throws StorageException {
        BranchesInfo branchInfo = ProjectBranchesService.getBranchesInfo(this.getPermissions(), false, this.openProjectIndex(ProjectRepositoryChangeIndex.class, null), this.getUser().getUsername());
        Set<String> branchNames = branchInfo.getAllBranches();
        CommitDescriptor resolvedCommitDescriptor = this.resolve(commitDescriptor);
        ForceRollbackService.performForcedRollback(resolvedCommitDescriptor, branchNames, this.getUser(), this.serviceInfo, this.criticalEventLogger);
    }
}

