/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin.profiler;

import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.admin.profiler.ProfilerConfiguration;
import com.teamscale.index.admin.profiler.ProfilerConfigurationIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.List;
import java.util.regex.Pattern;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/profiler-configurations")
public class ProfilerConfigurationsService
extends ApiBase {
    private static final Pattern ALLOWED_CONFIGURATION_ID_PATTERN = Pattern.compile("[a-zA-Z0-9._-]+");

    @GET
    @Path(value="{configurationId}")
    @RequiresBasicPermission(scope=EBasicPermissionScope.PROFILER_CONFIGURATIONS, permissions={EBasicPermission.VIEW}, entityPathParameter="configurationId")
    @Operation(summary="Get profiler configuration", description="Retrieves the profiler configuration identified by given ID.", tags={"Profilers"}, responses={@ApiResponse(responseCode="404", description="No profiler config with given ID found.")})
    public ProfilerConfiguration getProfilerConfiguration(@Parameter(description="ID of the profiler configuration to retrieve.") @PathParam(value="configurationId") String configurationId) throws StorageException, NotFoundException {
        ProfilerConfigurationIndex profilerConfigurationIndex = this.openGlobalIndex(ProfilerConfigurationIndex.class);
        ProfilerConfiguration profilerConfiguration = profilerConfigurationIndex.getProfilerConfiguration(configurationId);
        if (profilerConfiguration == null) {
            throw new NotFoundException(String.format("No profiler configuration with given ID '%s' found.", configurationId));
        }
        return profilerConfiguration;
    }

    @GET
    @Operation(summary="Get all profiler configurations", description="Retrieves all the defined profiler configurations", tags={"Profilers"})
    @RequiresNoPermission(description="No permissions needed, as the service will only return the profiler configurations visible to current user.")
    public List<ProfilerConfiguration> getAllProfilerConfigurations() throws StorageException {
        ProfilerConfigurationIndex profilerConfigurationIndex = this.openGlobalIndex(ProfilerConfigurationIndex.class);
        List profilerConfigurations = profilerConfigurationIndex.getAllProfilerConfigurations();
        profilerConfigurations.removeIf(profilerConfiguration -> !this.getPermissions().hasBasicPermission(EBasicPermissionScope.PROFILER_CONFIGURATIONS, profilerConfiguration.configurationId(), EBasicPermission.VIEW));
        return profilerConfigurations;
    }

    @POST
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_PROFILER_CONFIGURATIONS})
    @Operation(summary="Create profiler configuration", description="Creates a new profiler configuration.", tags={"Profilers"})
    public void createProfilerConfiguration(@RequestBody(required=true) ProfilerConfiguration configuration) throws StorageException {
        ProfilerConfigurationIndex profilerConfigurationIndex = this.openGlobalIndex(ProfilerConfigurationIndex.class);
        if (profilerConfigurationIndex.getProfilerConfiguration(configuration.configurationId()) != null) {
            throw new BadRequestException("A profiler configuration with ID " + configuration.configurationId() + " already exists.");
        }
        if (!ALLOWED_CONFIGURATION_ID_PATTERN.matcher(configuration.configurationId()).matches()) {
            throw new BadRequestException("Configuration " + configuration.configurationId() + " does not match allowed " + ALLOWED_CONFIGURATION_ID_PATTERN.pattern() + ".");
        }
        profilerConfigurationIndex.storeProfilerConfiguration(configuration);
        this.getPermissions().createPermissionModifier().makeCurrentUserOwner(EBasicPermissionScope.PROFILER_CONFIGURATIONS, configuration.configurationId());
    }

    @PUT
    @Path(value="{configurationId}")
    @RequiresBasicPermission(scope=EBasicPermissionScope.PROFILER_CONFIGURATIONS, permissions={EBasicPermission.EDIT}, entityPathParameter="configurationId")
    @Operation(summary="Update profiler configuration", description="Updates an existing profiler configuration.", tags={"Profilers"}, responses={@ApiResponse(responseCode="400", description="Configuration ID in URL and profiler configuration object does differ."), @ApiResponse(responseCode="404", description="No profiler configuration with given ID found.")})
    public void updateProfilerConfiguration(@Parameter(description="The ID of the dashboard to update.", required=true) @PathParam(value="configurationId") String configurationId, @RequestBody(required=true) ProfilerConfiguration configuration) throws StorageException {
        if (!configurationId.equals(configuration.configurationId())) {
            throw new BadRequestException("The ID must not be changed for a profiler configuration.");
        }
        this.getProfilerConfiguration(configurationId);
        ProfilerConfigurationIndex profilerConfigurationIndex = this.openGlobalIndex(ProfilerConfigurationIndex.class);
        profilerConfigurationIndex.storeProfilerConfiguration(configuration);
    }

    @DELETE
    @Path(value="{configurationId}")
    @RequiresBasicPermission(scope=EBasicPermissionScope.PROFILER_CONFIGURATIONS, permissions={EBasicPermission.DELETE}, entityPathParameter="configurationId")
    @Operation(summary="Remove profiler configuration", description="Removes the profiler configuration identified by given ID.", tags={"Profilers"}, responses={@ApiResponse(responseCode="404", description="No dashboard with given name found.")})
    public void deleteProfilerConfiguration(@Parameter(description="ID of the dashboard to retrieve.") @PathParam(value="configurationId") String configurationId) throws StorageException {
        this.getProfilerConfiguration(configurationId);
        ProfilerConfigurationIndex profilerConfigurationIndex = this.openGlobalIndex(ProfilerConfigurationIndex.class);
        profilerConfigurationIndex.removeProfilerConfiguration(configurationId);
        this.getPermissions().createPermissionModifier().removeBasicRoleInstanceAssignments(EBasicPermissionScope.PROFILER_CONFIGURATIONS, configurationId);
    }
}

