/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin.sap;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.option.OptionRegistryBase;
import com.teamscale.core.options.ShadowModeOption;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.runtime.api.progress.AnalysisState;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateIndex;
import com.teamscale.core.runtime.impl.scheduling.ProjectSchedulingFilter;
import com.teamscale.core.runtime.impl.worker.WorkerIndex;
import com.teamscale.index.repository.TimestampAdjustmentIndex;
import com.teamscale.index.repository.sap.abapsystem.AbapProjectUtils;
import com.teamscale.index.repository.sap.abapsystem.importer.AbapIncrementalSynchronizeTrigger;
import com.teamscale.index.sap.AbapTeamscaleSync;
import com.teamscale.index.sap.AbapTeamscaleSyncIndex;
import com.teamscale.service.admin.sap.SapSystemIdNotFoundException;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.time.Instant;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/sap-sysid-projects/{sysid}")
public class AbapTeamscaleSyncService
extends ApiBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/update")
    @PublicApi(since=ETeamscaleVersion.VERSION_5_7_0)
    @Operation(summary="Triggers ABAP Teamscale Sync", description="Incrementally synchronizes all ABAP projects with the given sap system id configured.", tags={"Project"}, responses={@ApiResponse(responseCode="500", description="SAP system id is not configured.")})
    @RequiresNoPermission
    public String synchronizeAbapProjects(@Parameter(description="The id of the SAP Netweaver system, which shall be configured under `Project Options` or the 'Global SAP Settings'.") @PathParam(value="sysid") String sapSystemId) throws StorageException {
        String configurationId = this.getConfigurationId(sapSystemId);
        AbapTeamscaleSyncIndex abapTeamscaleSyncIndex = this.openGlobalIndex(AbapTeamscaleSyncIndex.class);
        Class<AbapTeamscaleSyncIndex> clazz = AbapTeamscaleSyncIndex.class;
        synchronized (AbapTeamscaleSyncIndex.class) {
            Optional<String> syncId = abapTeamscaleSyncIndex.getSynchronizationId(configurationId);
            if (syncId.isEmpty()) {
                syncId = Optional.of(abapTeamscaleSyncIndex.registerAbapTeamscaleSync(configurationId));
                if (ShadowModeOption.isShadowModeEnabled((GlobalStorageSystem)this.getGlobalStorageSystem())) {
                    abapTeamscaleSyncIndex.setStateToCanceled(configurationId, syncId.get());
                } else {
                    this.scheduleAbapIncrementalSynchronizeTrigger(configurationId);
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return (String)syncId.get();
        }
    }

    @GET
    @Path(value="/is-updating/{updateid}")
    @PublicApi(since=ETeamscaleVersion.VERSION_5_7_0)
    @Operation(summary="Checks if any relevant ABAP project is synchronizing", description="Checks if any ABAP project with a configured SAP system id relative to the given synchronization id (to allow multiple synchronization requests) is currently synchronizing.", tags={"Project"}, responses={@ApiResponse(responseCode="500", description="SAP system id is not configured.")})
    @RequiresNoPermission
    public boolean areAbapProjectsUpdating(@Parameter(description="SAP system id.") @PathParam(value="sysid") String sapSystemId, @Parameter(description="Synchronization UUID.") @PathParam(value="updateid") String syncId) throws StorageException {
        AbapTeamscaleSyncIndex abapTeamscaleSyncIndex = this.openGlobalIndex(AbapTeamscaleSyncIndex.class);
        String configurationId = this.getConfigurationId(sapSystemId);
        AbapTeamscaleSync abapTeamscaleSync = AbapTeamscaleSyncService.getSynchronizationState(configurationId, syncId, abapTeamscaleSyncIndex);
        ProjectSchedulingFilter workerIndexSchedulingFilter = this.openGlobalIndex(WorkerIndex.class).getSchedulingFilterAccess().get();
        switch (abapTeamscaleSync.getState()) {
            case INITIATED: {
                return true;
            }
            case UPDATING: {
                if (this.isAnyCommitBeingProcessed(sapSystemId, abapTeamscaleSync, workerIndexSchedulingFilter)) {
                    return true;
                }
                abapTeamscaleSyncIndex.setStateToDone(configurationId, syncId);
                return false;
            }
            case DONE: 
            case CANCELED: {
                return false;
            }
        }
        CCSMAssert.fail((String)"No valid synchronization state.");
        return false;
    }

    private boolean isAnyCommitBeingProcessed(String sapSystemId, AbapTeamscaleSync abapTeamscaleSync, ProjectSchedulingFilter workerIndexSchedulingFilter) throws StorageException {
        for (InternalProjectId projectId : this.getProjectsWithSapSystemId(sapSystemId)) {
            Optional commitTime = abapTeamscaleSync.getCommitTime();
            if (!commitTime.isPresent() || this.isCommitProcessed((IProjectId)projectId, ((Instant)commitTime.get()).toEpochMilli()) || !workerIndexSchedulingFilter.isSchedulable(projectId)) continue;
            return true;
        }
        return false;
    }

    private String getConfigurationId(String sapSystemId) throws StorageException {
        List<InternalProjectId> projectIds = this.getProjectsWithSapSystemId(sapSystemId);
        if (projectIds.isEmpty()) {
            throw new SapSystemIdNotFoundException(sapSystemId);
        }
        ExternalCredentialsIndex externalCredentialsIndex = this.openGlobalIndex(ExternalCredentialsIndex.class);
        IndexLayer indexLayer = this.getIndexLayer();
        HashSet configurationIds = new HashSet();
        for (InternalProjectId projectId : projectIds) {
            configurationIds.addAll(AbapProjectUtils.resolveSapConfigurationIdsForProject((ExternalCredentialsIndex)externalCredentialsIndex, (MetaIndex)indexLayer.openMetaIndex((IProjectId)projectId)));
        }
        if (configurationIds.size() != 1) {
            throw new InternalServerErrorException("There must be exactly one SAP ABAP Connection for all projects with a configured SAP system id.");
        }
        return (String)configurationIds.iterator().next();
    }

    private List<InternalProjectId> getProjectsWithSapSystemId(String sapSystemId) throws StorageException, SapSystemIdNotFoundException {
        ProjectIndex projectIndex = this.getIndexLayer().openProjectIndex();
        List publicProjectIds = AbapProjectUtils.getProjects((String)sapSystemId, (IndexLayer)this.getIndexLayer(), (ServicePermissions)this.getPermissions());
        return CollectionUtils.mapWithException((Collection)publicProjectIds, arg_0 -> ((ProjectIndex)projectIndex).resolveToInternalId(arg_0));
    }

    private static AbapTeamscaleSync getSynchronizationState(String sapSystemId, String syncId, AbapTeamscaleSyncIndex abapTeamscaleSyncIndex) throws StorageException, NotFoundException {
        AbapTeamscaleSync synchronizationState = abapTeamscaleSyncIndex.getSynchronizationState(sapSystemId, syncId).orElse(null);
        if (synchronizationState == null) {
            throw new NotFoundException("No synchronization found with synchronization id " + syncId);
        }
        return synchronizationState;
    }

    private boolean isCommitProcessed(IProjectId projectId, long gitCommitTimestamp) throws StorageException {
        AnalysisState analysisState;
        CommitResolvingStorageSystem projectStorageSystem = this.getProjectStorageSystem(projectId);
        BranchAnalysisStateIndex branchAnalysisStateIndex = (BranchAnalysisStateIndex)projectStorageSystem.openProjectIndex(BranchAnalysisStateIndex.class, null);
        TimestampAdjustmentIndex timestampAdjustmentIndex = (TimestampAdjustmentIndex)projectStorageSystem.openProjectIndex(TimestampAdjustmentIndex.class, null);
        OptionalLong analysisTimestamp = timestampAdjustmentIndex.getOriginalTimestamp("master", Objects.requireNonNull(analysisState = branchAnalysisStateIndex.getAnalysisState("master")).getTimestamp().longValue());
        return analysisTimestamp.isPresent() && analysisTimestamp.getAsLong() >= gitCommitTimestamp && analysisState.getState() == EAnalysisState.LIVE_ANALYSIS;
    }

    private void scheduleAbapIncrementalSynchronizeTrigger(String configurationId) throws StorageException {
        JobDescriptor synchronizationJob = JobDescriptor.forMaintenanceProject().withPrivilegedTrigger(AbapIncrementalSynchronizeTrigger.class).withSchedulingReason("Scheduled due to findings retrieval of SAP system '" + configurationId + "'.").withParameter(OptionRegistryBase.buildMultiOptionId((String)"sap.abap.system", (String)configurationId)).build();
        ISchedulerCommunicator.getInstance().scheduleExternalJob(this.getIndexLayer(), synchronizationJob);
    }
}

