/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.architecture;

import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.index.architecture.assessment.ArchitectureAnnotator;
import com.teamscale.index.architecture.assessment.ArchitectureAssessor;
import com.teamscale.index.architecture.assessment.TypeToComponentMapper;
import com.teamscale.index.architecture.incremental.TypeComponentMapping;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.dependencies.TypeDependencyIndex;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.collections.UnmodifiableSet;

public class ArchitectureAssessmentHandler {
    public static ArchitectureDefinition getArchitectureDefinition(ArchitectureDefinition architecture, ListMap<String, String> typeToFilesLookup, TypeDependencyIndex typeDependencyIndex, SetMap<String, String> scope, IParallelTaskExecutor parallelTaskExecutor) throws ConQATException {
        TypeToComponentMapper mapper = new TypeToComponentMapper(architecture, parallelTaskExecutor);
        TypeToComponentMapper.MappingResult mappingResult = mapper.map(ArchitectureAssessmentHandler.getTypes(architecture, typeDependencyIndex, typeToFilesLookup));
        TypeComponentMapping typeComponentMapping = new TypeComponentMapping(mappingResult);
        UnmodifiableList allDependencies = new ArchitectureAssessor(architecture, scope, typeComponentMapping).getAllDependencies();
        ArchitectureAnnotator annotator = new ArchitectureAnnotator(architecture, typeComponentMapping, (List)allDependencies);
        annotator.assess();
        annotator.annotateArchitectureWithResult();
        return architecture;
    }

    private static List<String> getTypes(ArchitectureDefinition architectureDefinition, TypeDependencyIndex typeDependencyIndex, ListMap<String, String> typeFileLookupMap) throws StorageException {
        ArrayList<String> types = new ArrayList<String>();
        if (architectureDefinition.isFileBased()) {
            PairList typeDependencies = typeDependencyIndex.getAllTypeDependencies();
            types.addAll(typeDependencies.extractFirstList());
            typeDependencies.extractSecondList().stream().flatMap(Collection::stream).flatMap(t -> t.getDependencies().stream()).filter(type -> !typeFileLookupMap.containsCollection(type)).forEach(types::add);
        } else {
            List dependencies = typeDependencyIndex.getAllTypeDependencies().extractSecondList();
            for (ArrayList deps : dependencies) {
                types.addAll(deps.stream().map(TypeDependencies::getType).toList());
                for (TypeDependencies dep : deps) {
                    UnmodifiableSet dependencyLocations = dep.getDependencies();
                    types.addAll((Collection<String>)dependencyLocations);
                }
            }
        }
        return types;
    }
}

