/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.architecture;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.UserIndex;
import com.teamscale.index.architecture.ArchitectureAssessmentIndex;
import com.teamscale.index.architecture.ArchitectureAssessmentInfo;
import com.teamscale.index.architecture.ArchitectureAssessmentInfoUtils;
import com.teamscale.index.architecture.ArchitectureEditorUtils;
import com.teamscale.index.architecture.ArchitectureInfo;
import com.teamscale.index.architecture.ITypeToFileLookup;
import com.teamscale.index.architecture.external.ArchitectureUploadAnalysisStateIndex;
import com.teamscale.index.architecture.incremental.ArchitectureFileDependenciesIndex;
import com.teamscale.index.architecture.incremental.ArchitectureTypeDependenciesIndex;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.dependencies.TypeDependencyIndex;
import com.teamscale.index.dependencies.TypeIndex;
import com.teamscale.index.requirements_tracing.index.SpecItemHistoryIndex;
import com.teamscale.index.requirements_tracing.merge_request.SpecItemMappingToIdsEvaluator;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.service.architecture.ArchitectureAssessmentDto;
import com.teamscale.service.architecture.ArchitectureAssessmentDtoConverter;
import com.teamscale.service.architecture.ArchitectureAssessmentHandler;
import com.teamscale.service.architecture.ArchitectureAssessmentUtils;
import com.teamscale.service.architecture.ArchitectureOverviewHandler;
import com.teamscale.service.architecture.ArchitectureOverviewInfo;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/architectures/assessments")
public class ArchitectureAssessmentService
extends ApiBase {
    @GET
    @Path(value="{uniformPath}")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get architecture assessment", description="Returns the architecture assessment with the identifier in the path parameter. Returns an empty assessment if an unknown identifier is given.", tags={"Architecture"})
    public ArchitectureAssessmentDto getArchitectureAssessment(@Parameter(description="ID of the project where architecture is defined.") @PathParam(value="project") PublicProjectId projectId, @Parameter(description="Uniform path of requested architecture") @PathParam(value="uniformPath") @DefaultValue(value="") UniformPath uniformPath, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        this.checkArchitectureAssessmentIndexExists(projectId);
        HistoryAccessOption historyOption = this.determineHistoryOption(commit);
        ArchitectureAssessmentIndex architectureAssessmentIndex = this.openProjectIndex(ArchitectureAssessmentIndex.class, historyOption);
        TokenElementIndex contentIndex = this.openProjectIndex(TokenElementIndex.class, "content", historyOption);
        ArchitectureAssessmentInfo assessmentInfo = ArchitectureAssessmentUtils.getAssessmentInfo(uniformPath.toString(), architectureAssessmentIndex);
        ArchitectureDefinition architecture = ArchitectureAssessmentUtils.getArchitectureDefinition(uniformPath.toString(), contentIndex);
        ArchitectureAssessmentDtoConverter dtoConverter = this.createDtoConverter(architecture, historyOption.getBranchName());
        return dtoConverter.buildArchitectureAssessmentDto(architecture, assessmentInfo, (ProjectStorageSystem)this.getProjectStorageSystem(), historyOption, null, this.openGlobalIndex(UserIndex.class));
    }

    @GET
    @Path(value="type-to-file-lookup")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get a lookup mapping from types to files.", description="Returns the lookup mapping from types to files. In the context of architecture assessments the lookup can be used to map from unmapped types of type based architectures to their respective code file location.", tags={"Architecture"})
    public Map<String, String> getTypeToFileLookup(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws ConQATException {
        HistoryAccessOption historyOption = this.determineHistoryOption(commit);
        TypeIndex typeIndex = this.openProjectIndex(TypeIndex.class, historyOption);
        HashMap<String, String> result = new HashMap<String, String>();
        typeIndex.getTypeFileLookupMap().forEach(entry -> result.put((String)entry.getKey(), (String)((List)entry.getValue()).getFirst()));
        return result;
    }

    @GET
    @PublicApi(since=ETeamscaleVersion.VERSION_5_7_0)
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get all architecture assessments", description="Returns available architecture assessments. All architectures in analyzed and in pending commits are returned including tags on the state of their analysis (added, modified, deleted). Returns an empty list if no assessments available.", tags={"Architecture"})
    public List<ArchitectureOverviewInfo> getAllArchitectureAssessments(@Parameter(description="ID of the project where architectures are defined.") @PathParam(value="project") PublicProjectId projectId, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        this.checkArchitectureAssessmentIndexExists(projectId);
        HistoryAccessOption historyOption = this.determineHistoryOption(commit);
        ArchitectureAssessmentIndex architectureAssessmentIndex = this.openProjectIndex(ArchitectureAssessmentIndex.class, historyOption);
        Map<String, ArchitectureUploadAnalysisStateIndex.EArchitectureUploadType> uploadsInProgress = ArchitectureAssessmentUtils.getUploadsInProgress((ProjectStorageSystem)this.getProjectStorageSystem(), historyOption);
        BasicTokenElementIndex basicTokenElementIndex = this.openProjectIndex(BasicTokenElementIndex.class, historyOption);
        return ArchitectureOverviewHandler.getArchitectureInfos(architectureAssessmentIndex, uploadsInProgress, basicTokenElementIndex);
    }

    @POST
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Assess architecture definition", description="Returns the architecture assessment of the given architecture definition.", tags={"Architecture"})
    public ArchitectureAssessmentDto postArchitectureAssessment(@Parameter(description="ID of the project where architecture should be defined.") @PathParam(value="project") PublicProjectId projectId, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="A type search query pattern") @QueryParam(value="type-search") Pattern typeSearch, @RequestBody(description="Architecture data", required=true) ArchitectureInfo architectureInfo) throws ConQATException {
        this.checkProjectIndices(projectId);
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        ArchitectureDefinition architecture = ArchitectureEditorUtils.writeArchitectureDefinition((ArchitectureInfo)architectureInfo);
        SetMap<String, String> scope = this.getScope(architecture, historyAccessOption);
        TypeDependencyIndex typeDependencyIndex = this.openProjectIndex(TypeDependencyIndex.class, historyAccessOption);
        TypeIndex typeIndex = this.openProjectIndex(TypeIndex.class, historyAccessOption);
        ListMap typeToFilesLookup = typeIndex.getTypeFileLookupMap();
        ArchitectureDefinition annotatedArchitecture = ArchitectureAssessmentHandler.getArchitectureDefinition(architecture, (ListMap<String, String>)typeToFilesLookup, typeDependencyIndex, scope, this.getParallelTaskExecutor());
        ITypeToFileLookup typeToFileLookup = ITypeToFileLookup.create((ArchitectureDefinition)architecture, (ListMap)typeToFilesLookup);
        Set projectLanguages = AnalysisProfileUtils.getConfiguredLanguages((MetaIndex)this.openProjectIndex(MetaIndex.class, null));
        ArchitectureAssessmentInfo architectureAssessment = ArchitectureAssessmentInfoUtils.convertToAssessmentInfo((ArchitectureDefinition)annotatedArchitecture, (ITypeToFileLookup)typeToFileLookup, (Set)projectLanguages);
        ArchitectureAssessmentDtoConverter dtoConverter = this.createDtoConverter(architecture, historyAccessOption.getBranchName());
        return dtoConverter.buildArchitectureAssessmentDto(architecture, architectureAssessment, (ProjectStorageSystem)this.getProjectStorageSystem(), historyAccessOption, typeSearch, this.openGlobalIndex(UserIndex.class));
    }

    private void checkProjectIndices(PublicProjectId projectId) {
        if (!this.projectIndexExists("dependencies") || !this.projectIndexExists("type-dependencies")) {
            throw new InternalServerErrorException("Dependency list and type dependency indices do not exist. Please check if architecture analysis is enabled for project " + String.valueOf(projectId) + ".");
        }
    }

    private SetMap<String, String> getScope(ArchitectureDefinition architecture, HistoryAccessOption historyAccessOption) throws StorageException {
        if (architecture.isFileBased()) {
            ArchitectureFileDependenciesIndex architectureFileDependenciesIndex = this.openProjectIndex(ArchitectureFileDependenciesIndex.class, historyAccessOption);
            return architectureFileDependenciesIndex.getDependencies();
        }
        SetMap scope = new SetMap();
        ArchitectureTypeDependenciesIndex architectureTypeDependenciesIndex = this.openProjectIndex(ArchitectureTypeDependenciesIndex.class, historyAccessOption);
        Map dependencies = architectureTypeDependenciesIndex.getDependencyLocations();
        for (Map.Entry entry : dependencies.entrySet()) {
            scope.addAll((Object)((String)entry.getKey()), (Collection)((ListMap)entry.getValue()).getKeys());
        }
        return scope;
    }

    private ArchitectureAssessmentDtoConverter createDtoConverter(ArchitectureDefinition architecture, String branchName) throws StorageException {
        SpecItemMappingToIdsEvaluator specItemEvaluator = new SpecItemMappingToIdsEvaluator(this.openProjectIndex(SpecItemHistoryIndex.class, null), this.getGlobalStorageSystem(), (ProjectStorageSystem)this.getProjectStorageSystem(), this.getUser(), branchName);
        specItemEvaluator.evaluate(architecture);
        return new ArchitectureAssessmentDtoConverter(this.getPermissions(), specItemEvaluator);
    }

    private void checkArchitectureAssessmentIndexExists(PublicProjectId projectId) {
        if (!this.projectIndexExists("architecture-assessment")) {
            throw new InternalServerErrorException("Architecture assessment index does not exist. Please check if architecture analysis is enabled for project " + String.valueOf(projectId) + ".");
        }
    }
}

