/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.architecture;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.runtime.api.progress.AnalysisState;
import com.teamscale.core.runtime.api.rollback.RollbackRequest;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateIndex;
import com.teamscale.core.runtime.impl.rollback.ForceRollbackTrigger;
import com.teamscale.index.architecture.external.ExternalArchitectureUploadIndex;
import com.teamscale.service.architecture.ArchitectureExternalUploadInfoService;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.cache.SynchronizedCacheAccess;
import org.conqat.engine.persistence.index.schema.IndexSchema;
import org.conqat.engine.persistence.index.schema.IndexSchemaCache;
import org.conqat.engine.persistence.index.schema.SchemaEntry;
import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.branched.CommitLayeringBranchingLayer;
import org.conqat.engine.persistence.store.branched.IBranchingLayer;

@Path(value="api/projects/{project}/architectures")
public class ArchitectureUploadCleanerService
extends ApiBase {
    @DELETE
    @Path(value="all-unprocessed-uploads")
    @RequiresProjectPermission(value={EProjectPermission.EDIT_ARCHITECTURES})
    @Operation(summary="Delete all unprocessed architecture uploads", description="Deletes all commits of the architecture identified by the provided architecture path.", tags={"Architecture"})
    public void deleteAllUnprocessedArchitectureCommits(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @PathParam(value="project") PublicProjectId project) throws StorageException {
        Map<String, List<CommitDescriptor>> commits = this.extractArchitectureUploadInfoList(project, commit);
        HashMap<String, Long> rollbackBranches = new HashMap<String, Long>();
        BranchAnalysisStateIndex branchAnalysisStateIndex = this.openProjectIndex(BranchAnalysisStateIndex.class, null);
        for (Map.Entry<String, List<CommitDescriptor>> commitsPerBranch : commits.entrySet()) {
            AnalysisState analysisState = branchAnalysisStateIndex.getAnalysisState(commitsPerBranch.getKey());
            for (CommitDescriptor uploadCommit : commitsPerBranch.getValue()) {
                if (analysisState != null && uploadCommit.getTimestamp() <= analysisState.getTimestamp()) continue;
                ArchitectureUploadCleanerService.calculateRollbackInfo(uploadCommit, rollbackBranches);
            }
        }
        CommitLayeringBranchingLayer uploadBranchingLayer = this.openExternalResultBranchingLayer(project);
        uploadBranchingLayer.performRollback(rollbackBranches);
        this.scheduleRollback(rollbackBranches);
    }

    private Map<String, List<CommitDescriptor>> extractArchitectureUploadInfoList(PublicProjectId project, UnresolvedCommitDescriptor commit) throws StorageException {
        List<ArchitectureExternalUploadInfoService.ArchitectureCommitUploadInfo> uploads = commit.getBranchName() == null ? ArchitectureExternalUploadInfoService.extractArchitectureUploadInfoList(this.openExternalResultBranchingLayer(project)) : this.extractArchitectureUploadInfoListForBranch(project, commit.getBranchName());
        return uploads.stream().filter(upload -> upload.commit.getTimestamp() > commit.getTimestamp()).map(upload -> upload.commit).sorted(Comparator.reverseOrder()).collect(Collectors.groupingBy(CommitDescriptor::getBranchName));
    }

    private List<ArchitectureExternalUploadInfoService.ArchitectureCommitUploadInfo> extractArchitectureUploadInfoListForBranch(PublicProjectId project, String branch) throws StorageException {
        CommitLayeringBranchingLayer uploadBranchingLayer = this.openExternalResultBranchingLayer(project);
        ArrayList<ArchitectureExternalUploadInfoService.ArchitectureCommitUploadInfo> architectureUploadInfoList = new ArrayList<ArchitectureExternalUploadInfoService.ArchitectureCommitUploadInfo>();
        List allTimestampsOnBranch = uploadBranchingLayer.getAllTimestampsForBranch(branch);
        for (Long uploadTimestamp : allTimestampsOnBranch) {
            architectureUploadInfoList.add(ArchitectureExternalUploadInfoService.extractArchitectureCommitUploadInfo(uploadBranchingLayer, branch, uploadTimestamp));
        }
        return architectureUploadInfoList;
    }

    private static void calculateRollbackInfo(CommitDescriptor artificialUploadCommit, Map<String, Long> rollbackInfo) throws BadRequestException {
        CommitDescriptor rollbackCommit = artificialUploadCommit.cloneWithDecrementedTimestamp();
        rollbackInfo.merge(rollbackCommit.getBranchName(), rollbackCommit.getTimestamp(), Long::min);
    }

    private void scheduleRollback(Map<String, Long> rollbackInfos) throws StorageException {
        if (rollbackInfos.isEmpty()) {
            return;
        }
        ArrayList<CommitDescriptor> rollbackCommits = new ArrayList<CommitDescriptor>();
        for (Map.Entry<String, Long> entry : rollbackInfos.entrySet()) {
            CommitDescriptor commit = new CommitDescriptor(entry.getKey(), entry.getValue().longValue());
            rollbackCommits.add(commit);
        }
        JobDescriptor rollbackJob = JobDescriptor.forRollback((InternalProjectId)this.serviceInfo.getInternalId(), (RollbackRequest)new RollbackRequest(rollbackCommits, "scheduled due to deleting architecture uploads"), ForceRollbackTrigger.class);
        ISchedulerCommunicator.getInstance().scheduleExternalJob(this.getIndexLayer(), rollbackJob);
    }

    private CommitLayeringBranchingLayer openExternalResultBranchingLayer(PublicProjectId project) throws StorageException {
        SchemaEntry entry = IndexSchema.load((IStorageSystem)this.getProjectStorageSystem(), (SynchronizedCacheAccess)this.getIndexLayer().getStorageSystemCacheProvider(this.getIndexLayer().resolveToInternalProjectId((IProjectId)project).toString()).getCacheAccess(IndexSchemaCache.class)).getEntry("external-architecture-uploads");
        IStore commitLayeringBranchingLayer = this.openStoreInProject("external-architecture-uploads", ExternalArchitectureUploadIndex.class);
        return (CommitLayeringBranchingLayer)IBranchingLayer.create((IStore)commitLayeringBranchingLayer, (SchemaEntry)entry);
    }
}

