/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.service.audit.PathRegexGenerator;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.dotnet.resource.ProjectSourceExtractor;
import org.conqat.engine.dotnet.resource.SolutionProjectExtractor;
import org.conqat.engine.dotnet.resource.parser.ESolutionFormatVersion;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/audit/dotnet-source-paths-extractor")
public class DotNetSourcePathsExtractorService
extends ApiBase {
    private static final Pattern PROJECT_FILE_EXTENSION = Pattern.compile("(.*)[.]([^.]*)proj$");
    private final StringBuilder debugInfo = new StringBuilder();
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get included source file paths", description="Gets paths to all source files that are included in a project file which is included in a solution file. Requires the Project Connector to be configured so that only solution (.sln), project (.*proj) and source files (e.g. .cs, .cpp, .hpp, ...) are included. Also, solution (.sln) and project (.*proj) files need to be mapped to the language LINE.", tags={"Audit"})
    public List<String> getIncludedDotNetSourcePaths() throws StorageException {
        TreeSet<String> allSourcePaths = new TreeSet<String>();
        HashSet<BasicTokenElementInfo> solutionFiles = new HashSet<BasicTokenElementInfo>();
        TreeMap<String, Set<BasicTokenElementInfo>> solutionToProjectFiles = new TreeMap<String, Set<BasicTokenElementInfo>>();
        this.accessProjectIndex(allSourcePaths, solutionFiles, solutionToProjectFiles);
        Set<SourceFileInfo> sourceFileInfos = this.getSourceFileInfos(solutionToProjectFiles, allSourcePaths);
        Set fullIncludedSourcePathsKnown = sourceFileInfos.stream().filter(SourceFileInfo::known).map(SourceFileInfo::uniformPath).collect(Collectors.toCollection(TreeSet::new));
        Set<String> regexIncludedSourcePaths = PathRegexGenerator.makeRegexFromPaths(fullIncludedSourcePathsKnown, allSourcePaths);
        return this.generateStringArray(solutionToProjectFiles, sourceFileInfos, regexIncludedSourcePaths);
    }

    private List<String> generateStringArray(Map<String, Set<BasicTokenElementInfo>> solutionToProjectFile, Set<SourceFileInfo> sourceFileInfos, Set<String> regexIncludedSourcePaths) {
        ArrayList<String> strings = new ArrayList<String>();
        StringBuilder sb = new StringBuilder("## SOLUTION AND PROJECT FILES:\n");
        solutionToProjectFile.forEach((solutionPath, projectInfos) -> {
            sb.append("## PROJECT FILES FOUND IN '").append((String)solutionPath).append("':\n");
            for (BasicTokenElementInfo projectInfo : projectInfos) {
                sb.append("## ").append(projectInfo.getUniformPath()).append("\n");
            }
            sb.append("\n");
        });
        sb.append((CharSequence)this.debugInfo);
        strings.add(sb.toString());
        StringBuilder knownSourceFilePaths = new StringBuilder("## TO INCLUDE AS FULL PATHS (FILES KNOWN TO TS):\n");
        StringBuilder unknownSourceFilePaths = new StringBuilder("## TO INCLUDE AS FULL PATHS (FILES UNKNOWN TO TS):\n");
        DotNetSourcePathsExtractorService.appendFilePaths(sourceFileInfos, knownSourceFilePaths, unknownSourceFilePaths);
        strings.add(knownSourceFilePaths.toString());
        strings.add(unknownSourceFilePaths.toString());
        strings.add("## TO INCLUDE AS REGEX (FILES KNOWN TO TS):\n" + String.join((CharSequence)"\n", regexIncludedSourcePaths));
        strings.add(unknownSourceFilePaths.toString().replace("FULL PATHS", "REGEX"));
        return strings;
    }

    private static void appendFilePaths(Set<SourceFileInfo> sourceFileInfos, StringBuilder knownSourceFilePaths, StringBuilder unknownSourceFilePaths) {
        String currentProjectFile = "";
        for (SourceFileInfo sourceFileInfo : sourceFileInfos) {
            StringBuilder toWriteTo = sourceFileInfo.known() ? knownSourceFilePaths : unknownSourceFilePaths;
            if (!sourceFileInfo.projectFilePath().equals(currentProjectFile)) {
                currentProjectFile = sourceFileInfo.projectFilePath();
                toWriteTo.append("\n").append("## FROM '").append(currentProjectFile).append("':\n");
            }
            toWriteTo.append(sourceFileInfo.uniformPath()).append("\n");
        }
    }

    private void accessProjectIndex(Set<String> allSourcePaths, Set<BasicTokenElementInfo> solutionFiles, Map<String, Set<BasicTokenElementInfo>> solutionToProjectFiles) throws StorageException {
        BasicTokenElementIndex index = this.openProjectIndex(BasicTokenElementIndex.class, this.readDefaultBranchHead());
        Map allEntries = index.getAllTokenElements().toMap();
        Set<String> allKeys = allEntries.keySet();
        allSourcePaths.addAll(this.getAllSourcePaths(allKeys));
        solutionFiles.addAll(this.getSolutionFiles(allEntries));
        solutionToProjectFiles.putAll(this.getProjectFilesFromAllSolutionFiles(solutionFiles, allEntries));
    }

    private Set<BasicTokenElementInfo> getSolutionFiles(Map<String, BasicTokenElementInfo> allIndexEntries) {
        HashSet<BasicTokenElementInfo> solutionFiles = new HashSet<BasicTokenElementInfo>();
        allIndexEntries.forEach((uniformPath, file) -> {
            if (uniformPath.endsWith(".sln")) {
                solutionFiles.add((BasicTokenElementInfo)file);
            }
        });
        return solutionFiles;
    }

    private Map<String, Set<BasicTokenElementInfo>> getProjectFilesFromAllSolutionFiles(Set<BasicTokenElementInfo> solutionFiles, Map<String, BasicTokenElementInfo> allIndexEntries) {
        TreeMap<String, Set<BasicTokenElementInfo>> solutionToProjectFiles = new TreeMap<String, Set<BasicTokenElementInfo>>();
        for (BasicTokenElementInfo solutionFile : solutionFiles) {
            TreeSet<String> projectFilePaths = new TreeSet();
            try {
                projectFilePaths = SolutionProjectExtractor.extractAbsolutePaths((String)solutionFile.getText(), (String)solutionFile.getUniformPath());
            }
            catch (ConQATException e) {
                LOGGER.warn("'{}' is not a valid solution file: {}", (Object)solutionFile.getUniformPath(), (Object)e);
            }
            Set<BasicTokenElementInfo> projectFiles = this.getProjectFilesFromSingleSolutionFile(projectFilePaths, solutionFile.getUniformPath(), allIndexEntries);
            solutionToProjectFiles.put(solutionFile.getUniformPath(), projectFiles);
        }
        return solutionToProjectFiles;
    }

    private Set<BasicTokenElementInfo> getProjectFilesFromSingleSolutionFile(Set<String> projectFilePaths, String originSolutionFilePath, Map<String, BasicTokenElementInfo> allIndexEntries) {
        HashSet<BasicTokenElementInfo> projectFiles = new HashSet<BasicTokenElementInfo>();
        projectFilePaths.forEach(path -> {
            Optional<BasicTokenElementInfo> projectFile = this.getProjectFiles(originSolutionFilePath, allIndexEntries, (String)path);
            projectFile.ifPresent(projectFiles::add);
        });
        return projectFiles;
    }

    private Optional<BasicTokenElementInfo> getProjectFiles(String originSolutionFilePath, Map<String, BasicTokenElementInfo> allIndexEntries, String path) {
        BasicTokenElementInfo projectFile = allIndexEntries.get(path);
        if (projectFile == null) {
            this.debugInfo.append("## [PROJECT FILE FROM '").append(originSolutionFilePath).append("' NOT FOUND] ").append(path).append("\n");
            LOGGER.debug("Project file '{}' was found in solution file '{}', but not in Teamscale. The file might be excluded/not included.", (Object)path, (Object)originSolutionFilePath);
        }
        return Optional.ofNullable(projectFile);
    }

    private Set<SourceFileInfo> getSourceFileInfos(Map<String, Set<BasicTokenElementInfo>> solutionToProjectFiles, Set<String> allSourcePaths) {
        TreeSet<SourceFileInfo> sourceFileInfos = new TreeSet<SourceFileInfo>(Comparator.comparing(SourceFileInfo::known).thenComparing(SourceFileInfo::projectFilePath).thenComparing(SourceFileInfo::uniformPath));
        for (Set<BasicTokenElementInfo> projectFiles : solutionToProjectFiles.values()) {
            for (BasicTokenElementInfo projectFile : projectFiles) {
                Set sourceFilePaths = new TreeSet();
                try {
                    sourceFilePaths = ProjectSourceExtractor.extractAbsolutePaths((String)projectFile.getText(), (String)projectFile.getUniformPath());
                }
                catch (ConQATException e) {
                    LOGGER.warn("Project file '{}' could not be parsed: {}", (Object)projectFile.getUniformPath(), (Object)e);
                }
                catch (ESolutionFormatVersion.UnsupportedFormatException e) {
                    LOGGER.warn("Version of project file '{}' is unknown: {}", (Object)projectFile.getUniformPath(), (Object)e);
                }
                if (sourceFilePaths.isEmpty()) {
                    this.debugInfo.append("## [NO SOURCE FILES FOUND IN '").append(projectFile.getUniformPath()).append("']");
                }
                sourceFilePaths.forEach(path -> {
                    SourceFileInfo sourceFileInfo = new SourceFileInfo((String)path, allSourcePaths.contains(path), projectFile.getUniformPath());
                    sourceFileInfos.add(sourceFileInfo);
                });
            }
        }
        return sourceFileInfos;
    }

    private Set<String> getAllSourcePaths(Set<String> allIndexKeys) {
        return allIndexKeys.stream().filter(key -> !key.endsWith(".sln") && !PROJECT_FILE_EXTENSION.matcher((CharSequence)key).matches()).collect(Collectors.toSet());
    }

    private record SourceFileInfo(String uniformPath, boolean known, String projectFilePath) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SourceFileInfo that = (SourceFileInfo)o;
            return Objects.equals(this.uniformPath, that.uniformPath);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.uniformPath);
        }
    }
}

