/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.teamscale.index.audit.analysis.copyrightlicense.CopyrightLicenseIndex;
import com.teamscale.index.audit.analysis.copyrightlicense.CopyrightLicenseInfo;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import com.teamscale.index.resource.metrics.architecture.MetricsToArchitectureMetricsMappingIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@Path(value="api/projects/{project}/licenses")
public class LicenseService
extends ApiBase {
    public static final String CUSTOMER_LICENSE = "customer-license";
    public static final String CUSTOMER_LICENSE_DESCRIPTION = "The list of customer licenses that should be compared against. Comparison is case sensitive. Licenses are separated by commas.";
    private static final String UNIFORM_PATH_DESCRIPTION = "If given filters the results to this sub-path (including nested resources)";

    @GET
    @RequiresNoPermission
    @Operation(summary="Get licenses", description="Service to retrieve all licenses sorted by criticality", tags={"License"})
    public List<CopyrightLicenseInfo> getLicenses(@Parameter(description="The list of customer licenses that should be compared against. Comparison is case sensitive. Licenses are separated by commas.") @QueryParam(value="customer-license") List<String> customerLicensesList, @Parameter(description="If given filters the results to this sub-path (including nested resources)") @QueryParam(value="uniform-path") UniformPath uniformPath, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit) throws StorageException {
        if (uniformPath == null) {
            uniformPath = UniformPath.codeRoot();
        }
        HashSet<String> customerLicenses = new HashSet<String>(customerLicensesList);
        customerLicenses.remove("");
        return this.getLicenseInfoElements(uniformPath, commit).stream().filter(licenseInfoElement -> !StringUtils.containsOneOf((String)licenseInfoElement.getComment(), (Iterable)customerLicenses)).sorted().collect(Collectors.toList());
    }

    private List<CopyrightLicenseInfo> getLicenseInfoElements(UniformPath uniformPath, UnresolvedCommitDescriptor commit) throws StorageException {
        HistoryAccessOption historyOption = this.determineHistoryOption(commit);
        CopyrightLicenseIndex index = this.openProjectIndex(CopyrightLicenseIndex.class, historyOption);
        if (!uniformPath.isArchitecturePath()) {
            return index.getCopyrightLicenseInfoForPathsStartingWith(uniformPath.toString()).extractSecondList();
        }
        MetricsToArchitectureMetricsMappingIndex metricsMappingIndex = this.openProjectIndex(MetricsToArchitectureMetricsMappingIndex.class, historyOption);
        Set sourcesInArchitecture = ArchitectureMetricsUtils.getRecursivePathMappings((MetricsToArchitectureMetricsMappingIndex)metricsMappingIndex, (UniformPath)uniformPath).keySet();
        return CollectionUtils.filter((Collection)index.getCopyrightLicenseInfo(UniformPathCompatibilityUtil.asUniformPathStrings(sourcesInArchitecture)), Objects::nonNull);
    }
}

