/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.audit;

import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.directory.MetricDirectoryIndex;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricSchemaIndex;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.audit.AuditUtils;
import com.teamscale.service.audit.CodeFileInfo;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.regex.Pattern;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.regex.Patterns;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Path(value="api/projects/{project}/random-files")
public class RandomFilePickerService
extends ApiBase {
    public static final String MIN_FILE_SIZE_PARAMETER_NAME = "min";
    public static final String MAX_FILE_SIZE_PARAMETER_NAME = "max";
    public static final String REGEX_FILTER_PARAMETER_NAME = "regex";
    public static final String UNIFORM_PATH_PARAMETER_NAME = "uniform-path";
    private static final int NUMBER_OF_FILES = 10;

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Select random files.", description="Select files randomly for manual review in an audit.", tags={"Audit"})
    public List<CodeFileInfo> getRandomFilesInRange(@Parameter(description="The minimum file size in SLoC to be a valid selection.", required=true) @QueryParam(value="min") int min, @Parameter(description="The maximum file size in SLoC to be a valid selection.", required=true) @QueryParam(value="max") int max, @Parameter(description="Filters the randomly picked files by Java Regex(e.g. '*.java' only shows files ending with '.java')", required=true, allowEmptyValue=true) @QueryParam(value="regex") Pattern regex, @Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Uniform path to retrieve the random files for.", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath) throws StorageException {
        if (regex == null) {
            regex = Patterns.MATCH_ALL;
        }
        HistoryAccessOption historyOption = this.determineHistoryOption(commit);
        return this.selectFilesRandomlyInRange(min, max, regex, historyOption, uniformPath);
    }

    private List<CodeFileInfo> selectFilesRandomlyInRange(int minFileSize, int maxFileSize, Pattern regex, HistoryAccessOption historyOption, UniformPath uniformPath) throws StorageException {
        ArrayList<CodeFileInfo> result = new ArrayList<CodeFileInfo>();
        List<UniformPath> keys = AuditUtils.getSubUniformPaths((IStorageInfo)this.serviceInfo, historyOption, uniformPath);
        MetricDirectoryIndex metricDirectoryIndex = this.openProjectIndex(MetricDirectoryIndex.class, "metric-directory", historyOption);
        MetricDirectorySchema schema = this.openProjectIndex(MetricSchemaIndex.class, "metric-schema", historyOption.cloneToUnbranchedAccessOption()).getPublicSchema();
        while (!keys.isEmpty() && result.size() < 10) {
            int random = ThreadLocalRandom.current().nextInt(0, keys.size());
            UniformPath key = keys.get(random);
            if (RandomFilePickerService.isWithinFileSizeRange(key.toString(), minFileSize, maxFileSize, metricDirectoryIndex, schema) && regex.matcher(key.toString()).find()) {
                result.add(CodeFileInfo.create(key, metricDirectoryIndex, schema));
            }
            keys.remove(key);
        }
        return result;
    }

    private static boolean isWithinFileSizeRange(String key, int minFileSize, int maxFileSize, MetricDirectoryIndex metricDirectoryIndex, MetricDirectorySchema schema) throws StorageException, AssertionError {
        MetricDirectoryEntry entry = metricDirectoryIndex.getMetricDirectoryEntry(key);
        Object metricValue = entry.getValue(schema.getValuePosition("Source Lines of Code"));
        CCSMAssert.isNotNull((Object)metricValue, (String)"Obtained metric value null.");
        if (!(metricValue instanceof Number)) {
            throw new InternalServerErrorException("Obtained metric Value not a Number.");
        }
        Number fileSize = (Number)metricValue;
        return minFileSize <= fileSize.intValue() && fileSize.intValue() <= maxFileSize;
    }
}

