/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.authenticate;

import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.AuthenticationEntityNotFoundException;
import com.teamscale.core.authenticate.base.AuthenticationToolClientException;
import com.teamscale.core.authenticate.base.AuthenticationToolException;
import com.teamscale.core.authenticate.base.AuthenticationToolUtils;
import com.teamscale.core.authenticate.base.IAuthenticationToolProvider;
import com.teamscale.core.authenticate.base.IImportUsersStrategy;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.user.UserIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/auth/import/users")
public class ImportUsersService
extends ApiBase {
    @POST
    @Operation(summary="Import user", description="Imports one user from a remote server. Returns the name of the imported user.", responses={@ApiResponse(responseCode="404", description="The given server or user could not be found"), @ApiResponse(responseCode="500", description="The user already exists")}, tags={"Users"})
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_USERS})
    @Path(value="{userName}")
    public String importUser(@Parameter(description="The name of the user that should be imported.") @PathParam(value="userName") String userName, @Parameter(description="The name of the remote server.", required=true) @QueryParam(value="server-name") String serverName, @Parameter(description="The type of the remote server (e.g. ldap or crowd).", required=true) @QueryParam(value="server-type") EAuthenticationTool serverType) throws StorageException, AuthenticationToolException {
        UserIndex userIndex = this.openGlobalIndex(UserIndex.class);
        if (userIndex.getUser(userName) != null) {
            throw new BadRequestException("User '%s' already exists. Cannot import existing users!".formatted(userName));
        }
        try {
            IAuthenticationToolProvider toolProvider = AuthenticationToolUtils.getProvider((EAuthenticationTool)serverType, (GlobalStorageSystem)this.getGlobalStorageSystem(), (IMessageBroker)this.serviceInfo.getMessageBroker());
            IImportUsersStrategy userImportStrategy = toolProvider.createImportUsersStrategy(serverName);
            List users = userImportStrategy.importUser(userName);
            if (users.isEmpty()) {
                throw new NotFoundException("User '%s' not found on %s server: %s".formatted(userName, serverType, serverName));
            }
            this.getPermissions().createPermissionModifier().makeCurrentUserOwner(EBasicPermissionScope.USERS, userName);
            return userName;
        }
        catch (AuthenticationEntityNotFoundException e) {
            throw new NotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (AuthenticationToolClientException e) {
            throw new BadRequestException(e.getMessage(), (Throwable)e);
        }
    }
}

