/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.autocomplete;

import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class PrefixPriorityComparator<T>
implements Comparator<T> {
    private final Predicate<String> hasPriority;
    private final Function<? super T, String> keyExtractor;
    private final Comparator<? super String> downstreamComparator;

    public PrefixPriorityComparator(String token, boolean regex) {
        this(token, regex, Objects::toString);
    }

    public PrefixPriorityComparator(String token, boolean regex, Function<? super T, String> keyExtractor) {
        this(token, regex, keyExtractor, Comparator.naturalOrder());
    }

    public PrefixPriorityComparator(String token, boolean regex, Function<? super T, String> keyExtractor, Comparator<? super String> downstreamComparator) {
        if (regex) {
            Pattern pattern = Pattern.compile(token.toLowerCase());
            this.hasPriority = key -> pattern.matcher((CharSequence)key).lookingAt();
        } else {
            this.hasPriority = key -> key.startsWith(token.toLowerCase());
        }
        this.keyExtractor = keyExtractor;
        this.downstreamComparator = downstreamComparator;
    }

    @Override
    public int compare(T o1, T o2) {
        String key1 = this.keyExtractor.apply(o1).toLowerCase();
        String key2 = this.keyExtractor.apply(o2).toLowerCase();
        if (this.hasPriority.test(key1) == this.hasPriority.test(key2)) {
            return this.downstreamComparator.compare(key1, key2);
        }
        if (this.hasPriority.test(key1)) {
            return -1;
        }
        return 1;
    }
}

