/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.badge.preview;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.Callback;

public class BadgePreviewServer {
    public static void main(String[] args) throws Exception {
        Server server = new Server(8081);
        server.setHandler((Handler)new StaticHtmlHandler());
        System.out.println("Starting Jetty server on http://localhost:8081");
        server.start();
        server.join();
    }

    public static class StaticHtmlHandler
    extends Handler.Sequence {
        private static final String PAGE_WRAPPER = "<!DOCTYPE html>\n<html>\n<head>\n\t<meta charset=\"utf-8\">\n\t<meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">\n\t<title>Badge Comparison</title>\n\t<style>\n\t\timg { border: 1px black; }\n\t\t.up { top: -5px; position: relative; }\n\t</style>\n</head>\n<body>\n<h1>Badge Comparison</h1>\n{BADGES}\n</body>\n</html>\n";
        private static final String LOCAL_URL = "http://127.0.0.1:8080";
        private static final String PROD_URL = "https://cqse.teamscale.io";
        private static final Map<String, String> badges = Stream.of(Map.entry("commit-alerts", "/api/badges/commit-alerts/static?commitAlerts=123"), Map.entry("critical-change", "/api/badges/critical-change/static?title=Example&text=Some%20Text&color=%23f542cb&tooltip=Some%20tooltip%20text&link=https%3A%2F%2Fdocs.teamscale.com%2Fhowto%2Ftracking-critical-changes-in-merge-requests%2F%23tracking-of-critical-changes-in-merge-requests"), Map.entry("findings", "/api/badges/findings/static?added=123&changed=456&removed=789"), Map.entry("findings", "/api/badges/findings/static?removed=42"), Map.entry("findings (zero findings)", "/api/badges/findings/static?added=0&changed=0&removed=0"), Map.entry("metric-group", "/api/badges/metric-group/static?metricGroupName=Example&metricsWithoutData=10&deterioratedMetrics=20&stableMetrics=30&improvedMetrics=40&newThresholdViolations=50&incompleteBuildText=1%2F3"), Map.entry("metric (red)", "/api/badges/metric/static?metric=Example%20Metric&value=Example%20Value&color=RED&incompleteBuildText=1%2F4"), Map.entry("metric (orange)", "/api/badges/metric/static?metric=Example%20Metric&value=Example%20Value&color=ORANGE"), Map.entry("metric (yellow)", "/api/badges/metric/static?metric=Example%20Metric&value=Example%20Value&color=YELLOW&incompleteBuildText=1%2F4"), Map.entry("metric (green)", "/api/badges/metric/static?metric=Example%20Metric&value=A%20very%20long%20Example%20Value&color=GREEN&incompleteBuildText=1%2F4"), Map.entry("metric (baseline)", "/api/badges/metric/static?metric=Example%20Metric&value=Example%20Value&color=BASELINE&incompleteBuildText=1%2F4"), Map.entry("metric (unknown)", "/api/badges/metric/static?metric=Example%20Metric&value=Another%20Example%20Value&color=UNKNOWN&incompleteBuildText=1%2F4"), Map.entry("metric (without value)", "/api/badges/metric/static?metric=Example%20Metric&color=RED&incompleteBuildText=1%2F4"), Map.entry("spec-items (1)", "/api/badges/spec-items/static?affectedItems=1"), Map.entry("spec-items (123)", "/api/badges/spec-items/static?affectedItems=123"), Map.entry("spec-items (123456)", "/api/badges/spec-items/static?affectedItems=123456"), Map.entry("test-gap", "/api/badges/test-gap/static?ratio=0.42&testedChurn=10&untestedChange=20&untestedAddition=5&incompleteBuildText=1%2F2"), Map.entry("test-gap (assessment format)", "/api/badges/test-gap/static?ratio=0.42&testedChurn=10&untestedChange=20&untestedAddition=5&format=assessment&incompleteBuildText=1%2F2"), Map.entry("test-gap (assessment format, zero methods)", "/api/badges/test-gap/static?ratio=0.42&testedChurn=0&untestedChange=0&untestedAddition=0&format=assessment&incompleteBuildText=1%2F2"), Map.entry("project test-gap/issue badge error (View using Right-Click > Open Image in New Tab)", "/api/projects/foo/issues/18/findings-badge")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new));
        private final String CONTENT = StaticHtmlHandler.buildContent();

        public StaticHtmlHandler() {
            super(new Handler[0]);
        }

        private static String buildContent() {
            String badgesHtml = badges.entrySet().stream().map(entry -> String.format("<h2>%s</h2><img src=\"%s\"> <span class=\"up\">(local)</span><br><img src=\"%s\"> <span class=\"up\">(prod)</span><br>", entry.getKey(), LOCAL_URL + (String)entry.getValue(), PROD_URL + (String)entry.getValue())).collect(Collectors.joining());
            return PAGE_WRAPPER.replace("{BADGES}", badgesHtml);
        }

        public boolean handle(Request request, Response response, Callback callback) throws Exception {
            if (!"GET".equals(request.getMethod())) {
                return false;
            }
            response.setStatus(200);
            response.getHeaders().put("Content-Type", "text/html; charset=utf-8");
            response.write(true, ByteBuffer.wrap(this.CONTENT.getBytes(StandardCharsets.UTF_8)), callback);
            return true;
        }
    }
}

