/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.dashboard.widgets;

import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.repository.ECommitType;
import com.teamscale.index.repository.RepositoryLogFileEntry;
import com.teamscale.index.repository.RepositoryLogFileIndex;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.index.resource.VirtualCodePathUtils;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.base.TimeRange;
import com.teamscale.service.base.TimeRangeResourceServiceBase;
import com.teamscale.service.base.TimeRangeResourceServiceQueryOptions;
import com.teamscale.service.dashboard.widgets.AuthorCommits;
import com.teamscale.service.dashboard.widgets.CommitData;
import com.teamscale.service.dashboard.widgets.ECommitAuthorSortingOrder;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.user.UserResolveUtils;
import com.teamscale.service.user.UserResolvedRepositoryLogEntry;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.LongSummaryStatistics;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/commit-chart")
public class CommitTrackingService
extends TimeRangeResourceServiceBase {
    @GET
    @Operation(summary="Collect commits done by specific users", description="Retrieves a map from committing users to their commits.", tags={"Miscellaneous"}, responses={@ApiResponse(responseCode="400", description="Neither start timestamp nor time range provided."), @ApiResponse(responseCode="400", description="Provided end timestamp is smaller than start timestamp."), @ApiResponse(responseCode="400", description="Could not find any commit on the given branch in the given timespan.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public CommitData getUserToCommitMap(@BeanParam TimeRangeResourceServiceQueryOptions timeRangeParameters, @Parameter(description="The minimum commit count, an author needs to be included.") @QueryParam(value="commits") int commitCount, @Parameter(description="The sort order of the authors. Defaults to sorting by time.") @DefaultValue(value="TIME") @QueryParam(value="order") ECommitAuthorSortingOrder sortOrder) throws StorageException {
        UserAliasLookup userAliasLookup = UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem());
        List<ParentedCommitDescriptor> commitHistory = this.retrieveCommits(this.createTimeRange(timeRangeParameters));
        List<UserResolvedRepositoryLogEntry> repositoryEntries = this.retrieveRepositoryLogEntries(commitHistory, userAliasLookup);
        List<UserResolvedRepositoryLogEntry> repositoryEntriesInPaths = this.filterPaths(timeRangeParameters.getUniformPath(), repositoryEntries);
        LinkedHashMap<String, List<UserResolvedRepositoryLogEntry>> commitsByAuthors = CommitTrackingService.mapCommitsToAuthors(repositoryEntriesInPaths);
        LinkedHashMap<String, List<UserResolvedRepositoryLogEntry>> filteredEntries = CommitTrackingService.filterAuthors(commitCount, commitsByAuthors);
        if (filteredEntries.isEmpty()) {
            return new CommitData(0L, 0L, Collections.emptyList());
        }
        LongSummaryStatistics timestampData = filteredEntries.values().stream().flatMap(Collection::stream).mapToLong(CommitAssociatedObjectBase::getTimestamp).summaryStatistics();
        List<AuthorCommits> sortedEntries = CommitTrackingService.sortAndTransformAuthors(filteredEntries, sortOrder, userAliasLookup);
        return new CommitData(timestampData.getMin(), timestampData.getMax(), sortedEntries);
    }

    private List<ParentedCommitDescriptor> retrieveCommits(TimeRange timeRange) throws StorageException {
        CommitDescriptorIndex commitIndex = this.openProjectIndex(CommitDescriptorIndex.class, null);
        CommitDescriptor start = timeRange.start();
        CommitDescriptor end = timeRange.end();
        Optional firstCommit = commitIndex.getFirstActualCommitBeforeOrAt(end, start.getTimestamp());
        if (firstCommit.isEmpty()) {
            throw new BadRequestException("Could not find any commit on branch " + end.getBranchName() + " in the timespan " + start.getTimestamp() + " - " + end.getTimestamp());
        }
        return commitIndex.getCommitHistoryWithFirstParentCommits((CommitDescriptor)firstCommit.get(), start.getTimestamp());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private @NonNull List<UserResolvedRepositoryLogEntry> retrieveRepositoryLogEntries(List<ParentedCommitDescriptor> commitHistory, UserAliasLookup userAliasLookup) throws StorageException {
        RepositoryLogIndex logIndex = this.openProjectIndex(RepositoryLogIndex.class, null);
        @Nullable List entries = logIndex.getEntries(CollectionUtils.map(commitHistory, ParentedCommitDescriptor::getCommit));
        ArrayList<UserResolvedRepositoryLogEntry> result = new ArrayList<UserResolvedRepositoryLogEntry>();
        CollectionUtils.forEach((Iterable)entries, commitHistory, (entry, commit) -> {
            if (entry != null && entry.getCommitTypes().contains(ECommitType.CODE_COMMIT)) {
                result.add(UserResolveUtils.resolveRepositoryLogEntry(entry.toAggregateLogEntryWithPrimaryConnector(), commit, userAliasLookup));
            }
        });
        return result;
    }

    private List<UserResolvedRepositoryLogEntry> filterPaths(UniformPath pathPrefix, List<UserResolvedRepositoryLogEntry> unfilteredEntries) throws StorageException {
        List unfilteredCommits = CollectionUtils.map(unfilteredEntries, CommitAssociatedObjectBase::getCommit);
        Set<CommitDescriptor> commitsInPaths = this.filterCommitsByPaths(pathPrefix, unfilteredCommits);
        return CollectionUtils.filter(unfilteredEntries, commit -> commitsInPaths.contains(commit.getCommit()));
    }

    private Set<CommitDescriptor> filterCommitsByPaths(UniformPath pathPrefix, List<CommitDescriptor> commits) throws StorageException {
        RepositoryLogFileIndex logIndex = this.openProjectIndex(RepositoryLogFileIndex.class, null);
        ListMap entriesForCommits = logIndex.getEntriesForCommits(commits);
        HashSet<CommitDescriptor> keysFromStore = new HashSet<CommitDescriptor>();
        block0: for (Map.Entry entryForCommit : entriesForCommits) {
            Predicate includedPredicate = VirtualCodePathUtils.includedInResolvedTree((UniformPath)pathPrefix, (ProjectStorageSystem)this.getProjectStorageSystem(), (HistoryAccessOption)HistoryAccessOption.readCommit((CommitDescriptor)((CommitDescriptor)entryForCommit.getKey())));
            for (RepositoryLogFileEntry entry : (List)entryForCommit.getValue()) {
                if (!includedPredicate.test(entry.getUniformPath())) continue;
                keysFromStore.add(entry.getCommit());
                continue block0;
            }
        }
        return keysFromStore;
    }

    private static LinkedHashMap<String, List<UserResolvedRepositoryLogEntry>> mapCommitsToAuthors(List<UserResolvedRepositoryLogEntry> repositoryEntries) {
        LinkedHashMap<String, List<UserResolvedRepositoryLogEntry>> commitsByAuthors = new LinkedHashMap<String, List<UserResolvedRepositoryLogEntry>>();
        for (UserResolvedRepositoryLogEntry entry : repositoryEntries) {
            String author = Optional.ofNullable(entry.getResolvedAuthor()).map(User::getUsername).orElse(entry.getAuthor());
            commitsByAuthors.computeIfAbsent(author, ignored -> new ArrayList()).add(entry);
        }
        return commitsByAuthors;
    }

    private static LinkedHashMap<String, List<UserResolvedRepositoryLogEntry>> filterAuthors(int minimumCommits, LinkedHashMap<String, List<UserResolvedRepositoryLogEntry>> commitsByAuthors) {
        if (commitsByAuthors.size() > 1) {
            commitsByAuthors.remove("Teamscale import");
        }
        commitsByAuthors.values().removeIf(logEntries -> logEntries.size() < minimumCommits);
        return commitsByAuthors;
    }

    private static List<AuthorCommits> sortAndTransformAuthors(Map<String, List<UserResolvedRepositoryLogEntry>> filteredEntries, ECommitAuthorSortingOrder sortingOrder, UserAliasLookup userAliasLookup) {
        Comparator<AuthorCommits> comparator = switch (sortingOrder) {
            default -> throw new MatchException(null, null);
            case ECommitAuthorSortingOrder.NUMBER_OF_COMMITS -> Comparator.comparingInt(authorCommits -> authorCommits.getCommits().size());
            case ECommitAuthorSortingOrder.ALPHABETICALLY -> Comparator.comparing(authorCommits -> authorCommits.getFullName().toLowerCase(), Collections.reverseOrder());
            case ECommitAuthorSortingOrder.TIME -> Comparator.comparing(authorCommits -> ((UserResolvedRepositoryLogEntry)((Object)((Object)CollectionUtils.getLast(authorCommits.getCommits())))).getTimestamp());
        };
        ArrayList<AuthorCommits> list = new ArrayList<AuthorCommits>();
        filteredEntries.forEach((author, commits) -> {
            Optional teamscaleUser = userAliasLookup.resolveUser(author);
            if (teamscaleUser.isPresent()) {
                list.add(new AuthorCommits(((User)teamscaleUser.get()).getUsername(), ((User)teamscaleUser.get()).getFullName(), (List<UserResolvedRepositoryLogEntry>)commits));
            } else {
                list.add(new AuthorCommits(null, (String)author, (List<UserResolvedRepositoryLogEntry>)commits));
            }
        });
        list.sort(comparator);
        return list;
    }
}

