/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.documentation.analysis_profile;

import com.teamscale.service.documentation.DocumentationNodeBase;
import com.teamscale.service.documentation.analysis_profile.FindingDocumentation;
import com.teamscale.service.documentation.analysis_profile.OptionDocumentation;
import com.teamscale.service.documentation.layout.Layouter;
import eu.cqse.check.framework.core.EFindingEnablement;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.string.StringUtils;

public class CodeInspectorFindingDocumentation
extends FindingDocumentation {
    private static final Pattern CODE_INSPECTOR_RULE_ID_PATTERN = Pattern.compile("([^\\[]*)\\[([^\\]]*)\\].*");

    public CodeInspectorFindingDocumentation(String readableName, String description, EFindingEnablement enablement, String ruleId, List<OptionDocumentation> optionDocumentations) {
        super(readableName, description, enablement, CodeInspectorFindingDocumentation.getRuleId(ruleId, readableName), optionDocumentations);
    }

    private static String getRuleId(String ruleId, String name) {
        if (ruleId == null && name != null) {
            return name;
        }
        return ruleId;
    }

    @Override
    protected void layoutStart(Layouter layouter) {
        Matcher m = CODE_INSPECTOR_RULE_ID_PATTERN.matcher(this.ruleId);
        String testName = " ";
        String messageCode = " ";
        if (m.matches()) {
            testName = m.group(1);
            messageCode = m.group(2);
        }
        Object messageText = "Message of " + testName;
        if (!StringUtils.isEmpty((String)this.readableName)) {
            messageText = layouter.escape(this.readableName);
        }
        layouter.appendTableRow(new String[]{messageText, testName, messageCode, this.getEnablementText(false, layouter).trim()});
    }

    @Override
    protected <T extends DocumentationNodeBase<?>> int compareTo(T o) {
        if (!(o instanceof CodeInspectorFindingDocumentation)) {
            return super.compareTo(o);
        }
        CodeInspectorFindingDocumentation other = (CodeInspectorFindingDocumentation)o;
        return Comparator.comparing(codeInspectorFindingDoc -> codeInspectorFindingDoc.enablement).reversed().thenComparing(codeInspectorFindingDoc -> codeInspectorFindingDoc.ruleId).thenComparing(codeInspectorFindingDoc -> codeInspectorFindingDoc.readableName).compare(this, other);
    }
}

