/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.documentation.metric_thresholds;

import com.teamscale.core.analysis.configuration.index.MetricThresholdConfigurationIndex;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.core.permissions.roles.EBasicPermission;
import com.teamscale.core.permissions.roles.EBasicPermissionScope;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.documentation.layout.Layouter;
import com.teamscale.service.documentation.layout.MarkdownLayout;
import com.teamscale.service.documentation.metric_thresholds.ThresholdDocumentation;
import com.teamscale.service.framework.authorization.RequiresBasicPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.string.StringUtils;

@Path(value="api/threshold-configurations/{thresholdConfigurationName}/documentation")
public class ThresholdConfigurationDocumentationService
extends ApiBase {
    @GET
    @Operation(summary="Get threshold configuration documentation", description="Retrieves a text describing the specified threshold configuration")
    @RequiresBasicPermission(scope=EBasicPermissionScope.METRIC_THRESHOLD_CONFIGURATIONS, permissions={EBasicPermission.VIEW}, entityPathParameter="thresholdConfigurationName")
    public Response getThresholdConfigurationDocumentation(@PathParam(value="thresholdConfigurationName") String thresholdConfiguration) throws StorageException {
        MetricThresholdConfiguration configuration = this.getMetricThreshold(thresholdConfiguration);
        Layouter layouter = new Layouter(new MarkdownLayout());
        ThresholdDocumentation thresholdDocumentation = new ThresholdDocumentation(configuration.getName(), configuration);
        String thresholdProfileDocumentation = thresholdDocumentation.layout(layouter);
        String fileName = configuration.getName() + ".md";
        return ResponseUtils.getFileDownloadResponse((Object)StringUtils.stringToBytes((String)thresholdProfileDocumentation), (MediaType)MoreMediaTypes.TEXT_MARKDOWN_TYPE, (String)fileName);
    }

    private MetricThresholdConfiguration getMetricThreshold(String thresholdConfiguration) throws StorageException, BadRequestException {
        MetricThresholdConfigurationIndex metricThresholdConfigurationIndex = this.openGlobalIndex(MetricThresholdConfigurationIndex.class);
        MetricThresholdConfiguration thresholds = metricThresholdConfigurationIndex.getConfiguration(thresholdConfiguration);
        if (thresholds == null) {
            throw new BadRequestException("Threshold configuration '" + thresholdConfiguration + "' not found.");
        }
        return thresholds;
    }
}

