/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external.input;

import com.teamscale.core.concurrency.ExecuteInParallelBatchesFunction;
import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.rest.EHttpMethod;
import com.teamscale.core.rest.IExternalUploadRequestPart;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisImportSessionManager;
import com.teamscale.index.external.input.upload_sessions.ExternalAnalysisSessionInfo;
import com.teamscale.index.project.ExternalFindingsGroupDescriptionIndex;
import com.teamscale.index.report.generic.ExternalFindingFileData;
import com.teamscale.index.report.generic.GenericExternalFindingsParser;
import com.teamscale.index.resource.BinaryElementIndex;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementIndexCache;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.reportparser.parser.ReportParserException;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceBase;
import com.teamscale.service.external.input.SessionBasedExternalAnalysisServiceQueryOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;

@Path(value="api/projects/{project}/external-analysis/session/{sessionId}/external-findings")
public class SimpleExternalFindingImportService
extends SessionBasedExternalAnalysisServiceBase<SessionBasedExternalAnalysisServiceQueryOptions> {
    @POST
    @PublicApi(since=ETeamscaleVersion.VERSION_5_9_0)
    @Operation(summary="Upload external findings", description="Adds external findings to the session. For performance reasons, it is recommended to batch calls to this service, i.e. not commit all files using single calls.", tags={"External Analysis", "Findings"}, responses={@ApiResponse(responseCode="404", description="Revision provided in the query parameter could not be found."), @ApiResponse(responseCode="404", description="No session with provided id found."), @ApiResponse(responseCode="400", description="Partition name not provided."), @ApiResponse(responseCode="400", description="Provided partition name is different from the one used to create the session."), @ApiResponse(responseCode="400", description="Provided upload message is different from the one used to create the session."), @ApiResponse(responseCode="400", description="Upload was rejected, because it refers to a timestamp too far back in time."), @ApiResponse(responseCode="400", description="Session has been committed or deleted."), @ApiResponse(responseCode="400", description="Failed to parse provided report.")})
    @RequiresProjectPermission(value={EProjectPermission.EXTERNAL_UPLOADS})
    public void uploadExternalFindings(@Parameter(description="If session ID is provided, the results will be appended to the given session instead of creating a new session. Use \"auto-create\" in place of session ID to create a new session, perform upload and commit session in one step.") @PathParam(value="sessionId") String sessionId, @BeanParam SessionBasedExternalAnalysisServiceQueryOptions parameters, @RequestBody(required=true) List<ExternalFindingFileData> externalFindings) throws StorageException {
        ArrayList<ExternalFindingFileData> requestParts = new ArrayList<ExternalFindingFileData>(externalFindings);
        this.process(EHttpMethod.POST, requestParts, parameters, sessionId);
    }

    @Override
    protected void processRequest(ExternalAnalysisSessionInfo session, ExternalAnalysisImportSessionManager sessionManager, List<IExternalUploadRequestPart> externalData, SessionBasedExternalAnalysisServiceQueryOptions parameters) throws StorageException {
        HistoryAccessOption historyAccess = HistoryAccessOption.readTimestamp((String)session.getCommit().getBranchName(), (long)session.getCommit().getTimestamp());
        PathLookupIndex pathLookupIndex = this.openProjectIndex(PathLookupIndex.class, historyAccess);
        TokenElementIndexCache tokenElementIndexCache = new TokenElementIndexCache(this.openProjectIndex(TokenElementIndex.class, "content", historyAccess), Collections.emptyList());
        TokenElementLineInfoIndex tokenElementLineInfoIndex = this.openProjectIndex(TokenElementLineInfoIndex.class, historyAccess);
        BinaryElementIndex binaryElementIndex = this.openProjectIndex(BinaryElementIndex.class, historyAccess);
        ExternalFindingsGroupDescriptionIndex externalFindingsGroupDescriptionIndex = (ExternalFindingsGroupDescriptionIndex)this.getGlobalStorageSystem().openGlobalIndex(ExternalFindingsGroupDescriptionIndex.class);
        GenericExternalFindingsParser parser = new GenericExternalFindingsParser(false);
        parser.init(null, tokenElementIndexCache, tokenElementLineInfoIndex, binaryElementIndex, (IMatchingPathsLookup)pathLookupIndex, null, externalFindingsGroupDescriptionIndex, null, null, false, ExecuteInParallelBatchesFunction.createSingleThreadedExecutor(), null);
        ArrayList<ExternalFindingFileData> findings = new ArrayList<ExternalFindingFileData>();
        for (IExternalUploadRequestPart datum : externalData) {
            findings.add((ExternalFindingFileData)datum);
        }
        try {
            parser.parseReport(findings);
            sessionManager.storeNewImportInfosForSession(session, parser.getInfos());
        }
        catch (ReportParserException e) {
            throw new BadRequestException("Failed to parse report: " + e.getMessage(), (Throwable)e);
        }
    }
}

