/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external.input.external_storage.migration;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.permissions.ServicePermissions;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.runtime.api.scheduling.ISchedulerCommunicator;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackendIndex;
import com.teamscale.index.external.input.external_storage.ExternalStorageLookup;
import com.teamscale.index.external.input.external_storage.migration.ExternalStorageMigrationsIndex;
import com.teamscale.index.external.input.external_storage.migration.StorageBackendMigrationTrigger;
import com.teamscale.index.external.status.EExternalAnalysisProcessingStatus;
import com.teamscale.index.external.status.ExternalAnalysisProcessingStepInfo;
import com.teamscale.index.external.status.ExternalAnalysisStatusIndex;
import com.teamscale.index.external.status.ExternalAnalysisStatusInfo;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.stream.IStreamWithException;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.jspecify.annotations.NullMarked;

@NullMarked
@Path(value="api/external-storage/migrate-uploads/")
public class ExternalStorageMigrationService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final EnumSet<EProjectPermission> REQUIRED_PERMISSIONS = EnumSet.of(EProjectPermission.EDIT, EProjectPermission.EXTERNAL_UPLOADS);

    @POST
    @Path(value="{target}")
    @RequiresNoPermission(description="The user needs to have \"Edit Project\" and \"Perform External Uploads\" permissions on the given project IDs.")
    @Operation(summary="Migrate internally stored uploads to the external storage backend", description="Triggers a migration of all uploads in the given projects that were stored internally in Teamscale to the respective external storage backend for the project. If no project IDs are provided, all projects are migrated.", tags={"External Storage Backends"})
    public void triggerMigrations(@PathParam(value="target") String targetStorageName, @RequestBody List<PublicProjectId> projectIds) throws StorageException {
        if (CollectionUtils.isNullOrEmpty(projectIds)) {
            projectIds = this.getIndexLayer().openProjectIndex().getAllPrimaryPublicProjectIds();
        }
        this.throwIfMissingPermissions(projectIds);
        for (PublicProjectId projectId : projectIds) {
            this.migrateProject(projectId, targetStorageName);
        }
    }

    @POST
    @Path(value="{target}/{projectId}")
    @RequiresNoPermission(description="The user needs to have \"Edit Project\" and \"Perform External Uploads\" permissions on the given project ID.")
    @Operation(summary="Migrate internally stored uploads to the external storage backend", description="Triggers a migration of all uploads in the given project that were stored internally in Teamscale to the respective external storage backend for the project.", responses={@ApiResponse(responseCode="404", description="If no external storage is found for the given name.")}, tags={"External Storage Backends"})
    public void triggerMigration(@PathParam(value="projectId") PublicProjectId projectId, @PathParam(value="target") String targetStorageName) throws StorageException {
        this.throwIfMissingPermissions(List.of(projectId));
        this.migrateProject(projectId, targetStorageName);
    }

    @GET
    @Path(value="progress/{project}")
    @RequiresNoPermission(description="The user needs to have \"Edit Project\" and \"Perform External Uploads\" permissions on the given project ID.")
    @Operation(summary="Get a short progress report of the currently running migration.", tags={"External Storage Backends"})
    public String getProgress(@PathParam(value="project") PublicProjectId projectId) throws StorageException {
        this.throwIfMissingPermissions(Collections.singletonList(projectId));
        List<ExternalAnalysisStatusInfo> allStatuses = ExternalStorageMigrationService.getAllMigratedStatuses(this.getIndexLayer(), projectId);
        if (allStatuses.isEmpty()) {
            return "0/0 (0%)";
        }
        List<ExternalAnalysisStatusInfo> storedStatuses = ExternalStorageMigrationService.filterStoredStatuses(allStatuses);
        return "%s/%s (%s%%)".formatted(storedStatuses.size(), allStatuses.size(), storedStatuses.size() * 100 / allStatuses.size());
    }

    @GET
    @Path(value="progress")
    @RequiresNoPermission(description="Only shows projects on which the user has \"Edit Project\" and \"Perform External Uploads\" permissions.")
    @Operation(summary="Get short progress reports for all projects currently running migrations.", tags={"External Storage Backends"})
    public String getAllMigrationProgress() throws StorageException {
        List visibleProjects = this.getPermissions().getVisibleProjects(false, true);
        return (String)IStreamWithException.wrap(visibleProjects.stream()).withException(StorageException.class).map(ProjectInfo::getPrimaryPublicId).filter(this::userHasRequiredPermissions).map(this::getProjectProgressInfo).collect(Collectors.joining("\n"));
    }

    private String getProjectProgressInfo(PublicProjectId projectId) throws StorageException {
        return "%s: %s".formatted(projectId, this.getProgress(projectId));
    }

    public static List<ExternalAnalysisStatusInfo> getAllMigratedStatuses(IndexLayer indexLayer, PublicProjectId projectId) throws StorageException {
        return ((List)((ExternalAnalysisStatusIndex)indexLayer.openProjectIndex((IProjectId)projectId, ExternalAnalysisStatusIndex.class, null)).computeWithLock(ExternalAnalysisStatusIndex.LockedIndexAccess::getAllDetailedStatuses)).stream().filter(info -> info.getProcessingSteps().stream().anyMatch(ExternalAnalysisProcessingStepInfo::isStorageMigrationStep)).toList();
    }

    private static List<ExternalAnalysisStatusInfo> filterStoredStatuses(List<ExternalAnalysisStatusInfo> allStatuses) {
        return allStatuses.stream().filter(status -> status.getProcessingSteps().stream().anyMatch(step -> step.getStatus() == EExternalAnalysisProcessingStatus.STORED)).toList();
    }

    private void migrateProject(PublicProjectId projectId, String targetStorageName) throws StorageException, NotFoundException {
        ExternalStorageBackend externalStorageBackend = (ExternalStorageBackend)ExternalStorageLookup.getStorageBackend((InternalProjectId)this.getIndexLayer().resolveToInternalProjectId((IProjectId)projectId), (String)targetStorageName, (ExternalStorageBackendIndex)this.openGlobalIndex(ExternalStorageBackendIndex.class)).orElseThrow(() -> new NotFoundException("No external storage backend was found for " + targetStorageName));
        InternalProjectId internalProjectId = this.getIndexLayer().resolveToInternalProjectId((IProjectId)projectId);
        if (this.enableMigrationModeForProject(internalProjectId, externalStorageBackend)) {
            this.scheduleMigrationTrigger(internalProjectId, externalStorageBackend);
        }
    }

    private void scheduleMigrationTrigger(InternalProjectId internalProjectId, ExternalStorageBackend externalStorageBackend) throws StorageException {
        ISchedulerCommunicator.getInstance().scheduleExternalJob(this.getIndexLayer(), JobDescriptor.forMaintenanceProject().withPrivilegedTrigger(StorageBackendMigrationTrigger.class).withSchedulingReason("Upload migration scheduled by user service call.").withParameter((Object)new StorageBackendMigrationTrigger.JobParameter(internalProjectId, externalStorageBackend)).build());
    }

    private synchronized boolean enableMigrationModeForProject(InternalProjectId internalProjectId, ExternalStorageBackend externalStorageBackend) throws StorageException {
        ExternalStorageMigrationsIndex externalStorageMigrationsIndex = this.openGlobalIndex(ExternalStorageMigrationsIndex.class);
        Optional existingTarget = externalStorageMigrationsIndex.getMigrationTarget(internalProjectId);
        if (existingTarget.isPresent()) {
            if (((String)existingTarget.get()).equals(externalStorageBackend.externalStorageBackendName())) {
                LOGGER.info("Migration is already enabled. Nothing to do.");
                return false;
            }
            throw new BadRequestException("Migration is already enabled for external storage '%s'. A project can only migrate to one external storage at a time.".formatted(existingTarget.get()));
        }
        externalStorageMigrationsIndex.setMigrating(internalProjectId, externalStorageBackend);
        return true;
    }

    private void throwIfMissingPermissions(Collection<PublicProjectId> projectIds) throws StorageException {
        ServicePermissions permissions = this.getPermissions();
        for (PublicProjectId projectId : projectIds) {
            for (EProjectPermission requiredPermission : REQUIRED_PERMISSIONS) {
                permissions.checkProjectPermission((IProjectId)projectId, requiredPermission);
            }
        }
    }

    private boolean userHasRequiredPermissions(PublicProjectId projectId) throws StorageException {
        ServicePermissions permissions = this.getPermissions();
        return IStreamWithException.wrap(REQUIRED_PERMISSIONS.stream()).withException(StorageException.class).allMatch(projectPermission -> permissions.userHasProjectPermission((IProjectId)projectId, projectPermission));
    }
}

