/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.external.input.external_storage.migration.debug;

import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.external.input.external_storage.migration.MigratedArchivePathsIndex;
import com.teamscale.index.external.status.ExternalAnalysisProcessingStepInfo;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.external.input.external_storage.migration.ExternalStorageMigrationService;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.function.Predicate;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/external-storage/migrate-uploads/debug/")
public class ExternalStorageMigrationDebugService
extends ApiBase {
    @GET
    @Path(value="migrated-paths")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="List migrated paths", description="Lists all migrated paths stored in the index", tags={"External Storage Backends", "Debugging"})
    public List<String> getMigratedPaths() throws StorageException {
        return ((MigratedArchivePathsIndex)this.getIndexLayer().openGlobalIndex(MigratedArchivePathsIndex.class)).getAllPaths();
    }

    @GET
    @Path(value="{project}/migration-errors")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Operation(summary="Get errors during migration", description="Lists status updates with errors which are relevant for the storage migration.", tags={"External Storage Backends", "Debugging"})
    public List<String> getMigrationErrors(@PathParam(value="project") PublicProjectId project, @QueryParam(value="limit") @DefaultValue(value="1000") int limit) throws StorageException {
        return ExternalStorageMigrationService.getAllMigratedStatuses(this.getIndexLayer(), project).stream().flatMap(statusInfo -> statusInfo.getProcessingSteps().stream().filter(ExternalAnalysisProcessingStepInfo::isStorageMigrationStep).filter(Predicate.not(step -> step.getStatus().isReanalyzable())).filter(Predicate.not(ExternalAnalysisProcessingStepInfo::isSuccessful)).flatMap(step -> step.getMessages().stream())).limit(limit).toList();
    }
}

