/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.index.baseline.BaselineIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.findings.IBaselineServiceApi;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import java.util.List;
import org.conqat.engine.index.baseline.BaselineInfo;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/baselines")
public class BaselineService
extends ApiBase
implements IBaselineServiceApi {
    @Override
    public List<BaselineInfo> getAllBaselines() throws StorageException {
        return this.getIndex().getAllBaselines();
    }

    @Override
    public BaselineInfo getBaseline(String baseline) throws StorageException {
        BaselineInfo element = this.getIndex().getBaseline(baseline);
        if (element == null) {
            throw new NotFoundException("Baseline '" + baseline + "' doesn't exist.");
        }
        return element;
    }

    @Override
    public void createOrUpdateBaseline(String baseline, String oldBaselineName, BaselineInfo newBaselineInfo) throws StorageException {
        if (!baseline.equalsIgnoreCase(newBaselineInfo.getName())) {
            throw new BadRequestException("Baseline given in path and entity must match!");
        }
        if (oldBaselineName != null && !baseline.equals(oldBaselineName)) {
            this.deleteBaseline(oldBaselineName);
        }
        this.getIndex().setBaseline(baseline, newBaselineInfo);
    }

    @Override
    public void deleteBaseline(String baseline) throws StorageException {
        BaselineInfo currentBaseline = this.getIndex().getBaseline(baseline);
        if (currentBaseline == null) {
            throw new NotFoundException("Element doesn't exist: " + baseline);
        }
        this.getIndex().removeBaseline(currentBaseline.getName());
    }

    private BaselineIndex getIndex() throws StorageException {
        return this.openProjectIndex(BaselineIndex.class, null);
    }
}

