/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.findings.calculation.ExtendedFindingsWithCount;
import com.teamscale.service.findings.AbapElementFindingsService;
import com.teamscale.service.findings.ElementFindingsServiceBase;
import com.teamscale.service.findings.options.LegacyFindingsRequestOptions;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.LegacyApi;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.conqat.engine.abap.EAbapObjectType;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Hidden
@LegacyApi
@Path(value="p/{project}/abap-findings")
public class LegacyAbapElementFindingsService
extends ElementFindingsServiceBase {
    @Context
    private ResourceContext resourceContext;

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get all ABAP findings", description="Returns all findings for the given project.")
    public Response getAbapFindings(@BeanParam LegacyFindingsRequestOptions requestOptions) throws StorageException {
        ExtendedFindingsWithCount findingsWithCount = super.retrieveFilteredFindingsWithSortingAndPagination((UniformPath)UniformPath.codeRoot(), false, requestOptions.getFindingsFilterSettings(), requestOptions.getSortOptions(), requestOptions.getPaginationOptions());
        return this.applyLegacyType(findingsWithCount, requestOptions.getResponseFormat(), this.resolve(requestOptions.getFindingsFilterSettings().getCommit()));
    }

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Path(value="{objectType}/{sourceObject : .*}")
    @Operation(summary="Get ABAP findings", description="Returns findings for an ABAP source object, function group, or project. The element is expected in the form OBJTYPE/OBJNAME, e.g. 'PROG/ZTEST' or 'FUGR/!ABC!MY_FUNCTION_GROUP'.")
    public Response getAbapFindings(@PathParam(value="objectType") EAbapObjectType objectType, @PathParam(value="sourceObject") String objectName, @BeanParam LegacyFindingsRequestOptions requestOptions, @QueryParam(value="report-missing-objects") @Parameter(description="Whether missing source objects are logged in the service log.") @DefaultValue(value="true") boolean reportMissingObjects) throws StorageException {
        AbapElementFindingsService resource = (AbapElementFindingsService)this.resourceContext.getResource(AbapElementFindingsService.class);
        ExtendedFindingsWithCount abapFindings = resource.getAbapFindings(objectType, objectName, requestOptions.getFindingsFilterSettings(), reportMissingObjects);
        return this.applyLegacyType(abapFindings, requestOptions.getResponseFormat(), this.resolve(requestOptions.getFindingsFilterSettings().getCommit()));
    }
}

