/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.badge;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.findings.badge.IssueFindingBadgeService;
import com.teamscale.service.framework.authentication.Badge;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.LegacyApi;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.conqat.engine.persistence.store.StorageException;

@Hidden
@LegacyApi
@Path(value="p/{project}/issue-finding-badge.svg")
public class LegacyIssueFindingBadgeService
extends ApiBase {
    @Context
    private ResourceContext resourceContext;

    @GET
    @Path(value="{issueId}")
    @Badge
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get issue finding badge", description="Creates a finding badge for the given issue.")
    @Produces(value={"*/*"})
    public Response getIssueFindingBadge(@Parameter(description="ID of the issue to create a finding badge for. The format is the connector ID of the originating issue tracker/requirements management tool (as specified in the connector settings in the project configuration), followed by the separator '|', followed by the ID of the issue, as it is provided by the external issue tracker/requirements management tool. For example, an issue with the ID \"TS-123\" is imported using an issue tracker connector with the connector ID \"issues1\". The expected ID is then \"issues1|TS-123\". For compatibility reasons, using only the issue ID (e.g. \"TS-123\") is also supported but discouraged.") @PathParam(value="issueId") String issueId) throws StorageException {
        IssueFindingBadgeService resource = (IssueFindingBadgeService)this.resourceContext.getResource(IssueFindingBadgeService.class);
        try {
            return Response.ok((Object)resource.getIssueFindingBadge(issueId), (String)"image/svg+xml").build();
        }
        catch (InternalServerErrorException e) {
            return Response.ok((Object)"failure", (MediaType)MediaType.TEXT_PLAIN_TYPE).build();
        }
    }
}

