/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.findings.clangtidy;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.index.findings.CppIncludeHandler;
import com.teamscale.index.findings.CppToolAnalysisTokenElementDetails;
import com.teamscale.index.findings.clangtidy.ClangTidyRunner;
import com.teamscale.index.findings.clangtidy.ClangTidySynchronizer;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.CompileCommandIndex;
import com.teamscale.index.resource.FileIncludeLookup;
import com.teamscale.index.resource.SystemIncludeFileCacheIndex;
import com.teamscale.index.resource.SystemIncludeFileLookup;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.findings.SetupVerificationServiceUtils;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import eu.cqse.check.framework.scanner.ELanguage;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.distribution.LocalLockProvider;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.lib.commons.filesystem.CanonicalFile;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.jspecify.annotations.NonNull;

@Path(value="api/verify/clang-tidy-setup")
public class VerifyClangTidySetupService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String EXAMPLE_FILE_CONTENT = "int Main() {\n\tlong size = 294967296l;\n\tfor (short i = 0; i < size; ++i) {}\n}";
    private static final List<String> SELECTED_CHECKS = Arrays.asList("readability-identifier-naming", "bugprone-too-small-loop-variable");
    private static final Map<String, String> CHECK_OPTIONS = Collections.singletonMap("readability-identifier-naming.FunctionCase", "lower_case");
    private static final String EXPECTED_FINDINGS = "\tinvalid case style for function 'Main' at src/test.c:1-1\n\tloop variable has narrower type 'short' than iteration's upper bound 'long' at src/test.c:3-3";

    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.CREATE_ANALYSIS_PROFILES})
    @Operation(summary="Verifies that there is a clang-tidy installed on the server, has the required\n version, and can be called by Teamscale.", description="Verifies the clang-tidy installation on the server.", tags={"Source Code"})
    public String verifyClangTidySetup() throws StorageException, IOException {
        StringBuilder resultMessage = new StringBuilder("This service verifies that there is a clang-tidy installed on the Teamscale host. It checks whether the clang-tidy executable can be called, has the required version, and tries to analyze a small example program.\n\n");
        try {
            SetupVerificationServiceUtils.printVersionInformation(resultMessage, "clang-tidy-21", ClangTidyRunner.loadConfiguredClangTidyExe(), ClangTidySynchronizer.loadExpectedClangTidyVersion(), "com.teamscale.clang-tidy-exe");
            ClangTidySynchronizer.verifyClangTidyVersion();
            resultMessage.append("OK\n");
            resultMessage.append("\n\nSetting up test example in temporary directory.\n");
            VerifyClangTidySetupService.analyzeExampleCode(resultMessage);
        }
        catch (Throwable t) {
            resultMessage.append("Caught an exception (more details in the service log):\n");
            resultMessage.append(t.getMessage());
            resultMessage.append("\n");
            LOGGER.error((Object)t);
        }
        return resultMessage.toString();
    }

    private static @NonNull CppIncludeHandler buildIncludeHandler(TokenElementInfo mainFile) throws StorageException {
        TokenElementIndex contentIndex = new TokenElementIndex((IStore)new InMemoryStore());
        BasicTokenElementIndex basicContentIndex = new BasicTokenElementIndex((IStore)new InMemoryStore());
        CompileCommandIndex compileCommandIndex = new CompileCommandIndex((IStore)new InMemoryStore());
        contentIndex.setTokenElement(mainFile.getUniformPath(), mainFile);
        basicContentIndex.setTokenElement((BasicTokenElementInfo)mainFile);
        PathLookupIndex pathLookupIndex = new PathLookupIndex((IStore)new InMemoryStore());
        SystemIncludeFileLookup systemIncludeFileLookup = new SystemIncludeFileLookup(new SystemIncludeFileCacheIndex((IStore)new InMemoryStore()), Collections.emptyList());
        FileIncludeLookup fileIncludeLookup = new FileIncludeLookup((IMatchingPathsLookup)pathLookupIndex, systemIncludeFileLookup);
        return new CppIncludeHandler(basicContentIndex, compileCommandIndex, fileIncludeLookup, (ILockProvider)new LocalLockProvider());
    }

    private static void analyzeExampleCode(StringBuilder resultMessage) throws StorageException, IOException {
        TokenElementInfo mainFile = TokenElementInfo.createWithLocalPreprocessing((String)"src/test.c", (ELanguage)ELanguage.CPP, (String)EXAMPLE_FILE_CONTENT);
        ClangTidyRunner runner = new ClangTidyRunner(CodeScopeAware.defaultCodeScopeWithValue(CHECK_OPTIONS));
        File tempDir = new File(FileSystemUtils.getTmpDir(), "clang_tidy_setup_verifier_" + System.currentTimeMillis());
        resultMessage.append("Using temp dir ").append(tempDir.getAbsolutePath()).append("\n");
        SetupVerificationServiceUtils.setupCleanTargetDir(tempDir.getAbsolutePath());
        resultMessage.append("Using example file\n").append(EXAMPLE_FILE_CONTENT).append("\n");
        resultMessage.append("Using checks\n");
        for (String string : SELECTED_CHECKS) {
            resultMessage.append("\t").append(string).append("\n");
        }
        resultMessage.append("Using check option\n");
        for (Map.Entry entry : CHECK_OPTIONS.entrySet()) {
            resultMessage.append("\t").append((String)entry.getKey()).append(" -> ").append((String)entry.getValue()).append("\n");
        }
        resultMessage.append("Generating execution environment and running clang-tidy.\n");
        CodeScopeAware checkSelectorByLanguage = ClangTidySynchronizer.buildCheckSelectorsForCodeScopes((CodeScopeAware)CodeScopeAware.defaultCodeScopeWithValue(SELECTED_CHECKS), (CodeScopeAware)CodeScopeAware.defaultCodeScopeWithValue((Object)".*"), Collections.singleton(CodeScopeAware.DEFAULT_CODE_SCOPE));
        CodeScopeAware codeScopeAware = CodeScopeAware.defaultCodeScopeWithValue(Collections.emptyList());
        CppToolAnalysisTokenElementDetails tokenElementDetails = CppToolAnalysisTokenElementDetails.extractFromTokenElement((TokenElementInfo)mainFile);
        Map analysisResults = runner.prepareAndRunClangTidy(Collections.singletonList(mainFile), (File)new CanonicalFile(tempDir), checkSelectorByLanguage, codeScopeAware, false, VerifyClangTidySetupService.buildIncludeHandler(mainFile), tokenElementDetails);
        if (analysisResults.containsKey(mainFile.getUniformPath())) {
            resultMessage.append("generatedFindings:").append("\n");
            String actualFindings = SetupVerificationServiceUtils.formatFindingsString((List)analysisResults.get(mainFile.getUniformPath()));
            resultMessage.append(actualFindings);
            if (SetupVerificationServiceUtils.linesAreEqualAnyOrder(actualFindings, EXPECTED_FINDINGS)) {
                resultMessage.append("These are exactly the expected findings. Everything is ok.\n");
            } else {
                resultMessage.append("These are not exactly the expected findings. Something is wrong.\n");
                resultMessage.append("The expected findings are:\n").append(EXPECTED_FINDINGS);
            }
        } else {
            resultMessage.append("Clang-Tidy did not generate findings (something is wrong).\n");
        }
    }
}

