/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.git.debug;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.debug.DebugDumperRegistry;
import com.teamscale.core.debug.EDebugDumpEvent;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.rest.MoreMediaTypes;
import com.teamscale.index.repository.git.GitMainRepository;
import com.teamscale.index.repository.git.GitRepositoryConnection;
import com.teamscale.index.repository.git.GitRepositoryConnector;
import com.teamscale.index.repository.git.GitRepositoryConnectorDescriptor;
import com.teamscale.index.repository.git.GitRepositoryInfoIndex;
import com.teamscale.index.repository.git.GitUtils;
import com.teamscale.index.repository.git.cross_repo_merge_requests.CrossRepositoryMergeRequestSourceBranchesIndex;
import com.teamscale.index.repository.git.debug_dump.dump.GitRepositoryDebugDumper;
import com.teamscale.index.repository.git.debug_dump.dump.GitRepositoryDump;
import com.teamscale.index.repository.git.labeling.GitDebugInformation;
import com.teamscale.index.repository.git.labeling.PathBuildingBranchLabeler;
import com.teamscale.index.repository.git.labeling.TestCommitGraphNode;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import com.teamscale.service.repository.GitRepositoryConnectorUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.core.stream.IStreamWithException;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;
import org.eclipse.jgit.revwalk.RevCommit;
import org.jspecify.annotations.NonNull;

@Path(value="api/projects/{project}/git/debug/information")
public class DebugGitInformationDumpService
extends ApiBase {
    private static final String GIT_DUMP_FILE_NAME_PREFIX = "git-dump-";

    @GET
    @Path(value="{connectorId}")
    @Operation(summary="Get git information", description="Returns all git repository information regarding one connector for debugging labeling problems easily.", tags={"Debugging"}, responses={@ApiResponse(responseCode="400", description="The given connector is not a valid connector.")})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Produces(value={"application/json"})
    public byte[] getGitInformation(@Parameter(description="The ID of the connector") @PathParam(value="connectorId") String connectorId) throws StorageException {
        try {
            GitRepositoryInfoIndex gitInfoIndex = this.openGitInfoIndex(connectorId);
            GitRepositoryConnector connector = this.buildRepositoryConnector(gitInfoIndex, connectorId);
            GitRepositoryConnection connection = GitRepositoryConnectorUtils.createGitRepositoryConnection(connector, this.getIndexLayer());
            GitMainRepository repository = connection.getMainRepository();
            ArrayList<TestCommitGraphNode> sortedCommits = this.getCommitsFromRepository(connection, repository, connectorId);
            PathBuildingBranchLabeler labeler = DebugGitInformationDumpService.getPathBuildingBranchLabeler(gitInfoIndex, connection);
            GitDebugInformation debugInformation = DebugGitInformationDumpService.gitDebugInformation(gitInfoIndex, connector, sortedCommits, labeler);
            connection.close();
            return StringUtils.stringToBytes((String)JsonUtils.serializeToJSONPrettyPrinted((Object)debugInformation));
        }
        catch (ProjectConfigurationException | ConQATException | RepositoryException e) {
            throw new BadRequestException("Could not load connector " + connectorId, e);
        }
    }

    @POST
    @Path(value="{connectorId}/trigger-full-dump")
    @Operation(summary="Trigger full git debug dump", description="Triggers a complete debug dump of all labeling-related information during the next regularly scheduled commit tree expansion. This uses the infrastructure of the git debug dumper, which requires some environment variables to be set. Minimally, com.teamscale.debug-dump.enabled=true and com.teamscale.debug-dump.path=/some/path need to be set. Optionally, use com.teamscale.debug-dump.projects=(project1|project2) to restrict this further.", tags={"Debugging"}, responses={@ApiResponse(responseCode="400", description="The given repository ID is not valid."), @ApiResponse(responseCode="501", description="Debug dump requested, but debug dumper not enabled in system properties")})
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public Response triggerGitDebugDumpOnNextCommitTreeExpansion(@Parameter(description="The ID of the connector") @PathParam(value="connectorId") String connectorId) {
        try {
            ProjectIndex projectIndex = this.openGlobalIndex(ProjectIndex.class);
            if (!DebugDumperRegistry.isEnabled((EDebugDumpEvent)EDebugDumpEvent.GIT_TRIGGERED_ROLLBACK, (ProjectInfo)projectIndex.resolveProject((IProjectId)this.serviceInfo.getInternalId()))) {
                return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).entity((Object)"Triggering a debug dump requires the system variables com.teamscale.debug-dump.enabled=true as well as com.teamscale.debug-dump.path=/some/path to be set.").build();
            }
            this.openGitInfoIndex(connectorId).setDebugDumpRequested(true);
            return Response.ok((Object)"Debug dump requested successfully. It will be created during the next scheduled commit tree expansion.").build();
        }
        catch (ConQATException e) {
            throw new BadRequestException("Could not load repository " + connectorId, (Throwable)e);
        }
    }

    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Path(value="git-dump")
    @Operation(summary="Returns a git repository dump of the given project.", description="The dump contains the output of a `git log` command and a list of all branch pointers and their respective commits for all git connectors of the project.", tags={"Debugging"})
    @Produces(value={"application/zip"})
    public Response getGitDumpForProject() throws Exception {
        Stream<Pair<String, GitRepositoryDump>> gitDumpByRepoId = this.getConnectors().stream().map(ConnectorConfiguration::getIdentifier).map(repositoryId -> Pair.createPair((Object)repositoryId, (Object)this.getGitRepositoryDump((String)repositoryId)));
        StreamingOutput zipOutput = DebugGitInformationDumpService.getZipOutputStreamForGitDumps(gitDumpByRepoId);
        return ResponseUtils.getFileDownloadResponse((Object)zipOutput, (MediaType)MoreMediaTypes.APPLICATION_ZIP_TYPE, (String)(GIT_DUMP_FILE_NAME_PREFIX + String.valueOf(this.serviceInfo.getPrimaryPublicId()) + ".zip"));
    }

    @GET
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    @Path(value="git-dump/{repositoryId}")
    @Operation(summary="Returns a git repository dump of the given project and repository.", description="The dump contains the output of a `git log` command and a list of all branch pointers and their respective commits.", tags={"Debugging"})
    @Produces(value={"application/zip"})
    public Response getGitDumpForRepository(@PathParam(value="repositoryId") String repositoryId) throws Exception {
        GitRepositoryDump gitDump = this.getGitRepositoryDump(repositoryId);
        StreamingOutput zipOutput = DebugGitInformationDumpService.getZipOutputStreamForGitDumps(Stream.of(Pair.createPair((Object)repositoryId, (Object)gitDump)));
        return ResponseUtils.getFileDownloadResponse((Object)zipOutput, (MediaType)MoreMediaTypes.APPLICATION_ZIP_TYPE, (String)(GIT_DUMP_FILE_NAME_PREFIX + repositoryId + ".zip"));
    }

    private static @NonNull StreamingOutput getZipOutputStreamForGitDumps(Stream<Pair<String, GitRepositoryDump>> repoIdAndGitDumps) {
        return output -> {
            try (ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(output));){
                IStreamWithException.wrap((Stream)repoIdAndGitDumps).withException(IOException.class).forEach(repoIdAndGitDump -> DebugGitInformationDumpService.writeToZip((Pair<String, GitRepositoryDump>)repoIdAndGitDump, zipOutputStream));
            }
        };
    }

    private static void writeToZip(Pair<String, GitRepositoryDump> entry, ZipOutputStream zipOutputStream) throws IOException {
        zipOutputStream.putNextEntry(new ZipEntry((String)entry.getFirst() + ".json"));
        zipOutputStream.write(JsonUtils.serializeToJSON((Object)entry.getSecond()).getBytes(StandardCharsets.UTF_8));
        zipOutputStream.closeEntry();
    }

    private @NonNull GitRepositoryDump getGitRepositoryDump(String repositoryId) {
        try {
            GitRepositoryConnection connection = this.getGitRepositoryConnection(repositoryId);
            GitMainRepository repository = connection.getMainRepository();
            GitRepositoryDump repositoryDump = GitRepositoryDebugDumper.getRepositoryDump((GitMainRepository)repository);
            connection.close();
            return repositoryDump;
        }
        catch (ProjectConfigurationException | RepositoryException | StorageException e) {
            throw new BadRequestException("Could not load repository " + repositoryId, e);
        }
    }

    private GitRepositoryConnection getGitRepositoryConnection(String repositoryId) throws StorageException, ProjectConfigurationException, RepositoryException {
        GitRepositoryInfoIndex gitInfoIndex = this.openGitInfoIndex(repositoryId);
        GitRepositoryConnector connector = this.buildRepositoryConnector(gitInfoIndex, repositoryId);
        return GitRepositoryConnectorUtils.createGitRepositoryConnection(connector, this.getIndexLayer());
    }

    private GitRepositoryConnector buildRepositoryConnector(GitRepositoryInfoIndex gitInfoIndex, String repositoryId) throws StorageException, ProjectConfigurationException {
        GitRepositoryConnectorDescriptor repositoryConnectorDescriptor = this.getGitRepositoryConnectorDescriptor(repositoryId);
        return GitRepositoryConnectorUtils.createGitRepositoryConnector(repositoryConnectorDescriptor, gitInfoIndex, this.serviceInfo.getPrimaryPublicId(), repositoryId, this.getIndexLayer());
    }

    private GitRepositoryConnectorDescriptor getGitRepositoryConnectorDescriptor(String connectorId) throws BadRequestException, StorageException, ProjectConfigurationException {
        ConnectorConfiguration connectorInfo = this.getConnectors().stream().filter(connector -> Objects.equals(connector.getOptionValue("Connector Identifier"), connectorId)).findFirst().orElseThrow(() -> new BadRequestException("Could not find connector with ID " + connectorId));
        GlobalStorageSystem globalStorageSystem = this.getGlobalStorageSystem();
        ConfigurationInitializationContext context = new ConfigurationInitializationContext(this.getUser().getUsername(), this.getIndexLayer(), (IExternalCredentialsProvider)globalStorageSystem.openGlobalIndex(ExternalCredentialsIndex.class), ConfigurationInitializationContext.EInitializationReason.OTHER);
        ConnectorDescriptorBase loadedConnector = ConnectorUtils.loadConnector((ConnectorConfiguration)connectorInfo, (ConfigurationInitializationContext)context, (InternalProjectId)this.serviceInfo.getInternalId());
        if (!(loadedConnector instanceof GitRepositoryConnectorDescriptor)) {
            throw new BadRequestException("Connector with ID " + connectorId + " is not a git connector!");
        }
        return (GitRepositoryConnectorDescriptor)loadedConnector;
    }

    private List<ConnectorConfiguration> getConnectors() throws StorageException {
        return CollectionUtils.filter((Collection)((ProjectConfiguration)this.openProjectIndex(MetaIndex.class, null).getValue(ProjectConfiguration.class)).getConnectors(), ConnectorConfiguration::isGitBased);
    }

    private static PathBuildingBranchLabeler getPathBuildingBranchLabeler(GitRepositoryInfoIndex gitInfoIndex, GitRepositoryConnection connection) throws StorageException, RepositoryException {
        CrossRepositoryMergeRequestSourceBranchesIndex crossRepositoryIndex = new CrossRepositoryMergeRequestSourceBranchesIndex((IStore)new InMemoryStore());
        GitRepositoryConnection.RawCommitGraph rawCommitGraph = (GitRepositoryConnection.RawCommitGraph)crossRepositoryIndex.computeWithLock(lockedIndexAccess -> connection.buildCommitGraph(Collections.emptyList(), lockedIndexAccess));
        return new PathBuildingBranchLabeler(gitInfoIndex.getBranchNamesByCommitName(), Collections.emptyMap(), rawCommitGraph.nodesByName(), rawCommitGraph.branchHeadRefs(), connection.getBranchPrioritizer(), arg_0 -> ((GitRepositoryConnection)connection).isBranchNameIncludedOrDefaultBranch(arg_0));
    }

    private static GitDebugInformation gitDebugInformation(GitRepositoryInfoIndex gitInfoIndex, GitRepositoryConnector connector, ArrayList<TestCommitGraphNode> sortedCommits, PathBuildingBranchLabeler labeler) throws StorageException, RepositoryException {
        return new GitDebugInformation(sortedCommits, new PairList(gitInfoIndex.getBranchNamesByCommitName()), new PairList(labeler.extractBranchesWithHeadCommit()), connector.getBaseParameters().getDefaultBranchName());
    }

    private ArrayList<TestCommitGraphNode> getCommitsFromRepository(GitRepositoryConnection connection, GitMainRepository repository, String repositoryId) throws RepositoryException, StorageException {
        HashMap<String, TestCommitGraphNode> idToCommitGraphNode = new HashMap<String, TestCommitGraphNode>();
        for (RevCommit revCommit : repository.getAllCommits()) {
            if (GitUtils.getCommitTime((RevCommit)revCommit).isBefore(connection.getAnalysisStart())) continue;
            TestCommitGraphNode testCommit = new TestCommitGraphNode(revCommit.getName(), revCommit.getFullMessage(), (long)revCommit.getCommitTime());
            idToCommitGraphNode.put(testCommit.getName(), testCommit);
        }
        this.resolveParentsAndBranchNames(repositoryId, connection, repository, idToCommitGraphNode);
        ArrayList<TestCommitGraphNode> commits = new ArrayList<TestCommitGraphNode>(idToCommitGraphNode.values());
        Collections.sort(commits);
        return commits;
    }

    private void resolveParentsAndBranchNames(String repositoryId, GitRepositoryConnection connection, GitMainRepository repository, Map<String, TestCommitGraphNode> idToCommitGraphNode) throws RepositoryException, StorageException {
        CommitTreeIndex commitTree = this.openProjectIndex(CommitTreeIndex.class, CommitTreeIndex.getIndexNameForRepository((String)repositoryId), null);
        Map<String, String> commitNameToBranchMapping = commitTree.loadTree().getAllNodes().stream().collect(Collectors.toMap(node -> node.getRevision().getRevision(), node -> node.getRevision().getBranchName()));
        for (RevCommit revCommit : repository.getAllCommits()) {
            if (GitUtils.getCommitTime((RevCommit)revCommit).isBefore(connection.getAnalysisStart())) continue;
            TestCommitGraphNode commitNode = idToCommitGraphNode.get(revCommit.getName());
            for (RevCommit parent : revCommit.getParents()) {
                TestCommitGraphNode parentNode = idToCommitGraphNode.get(parent.getName());
                if (parentNode == null) continue;
                commitNode.addParent(parentNode);
            }
            commitNode.setBranchName(commitNameToBranchMapping.get(commitNode.getName()));
        }
    }

    private GitRepositoryInfoIndex openGitInfoIndex(String connectorId) throws StorageException {
        return this.openProjectIndex(GitRepositoryInfoIndex.class, GitRepositoryInfoIndex.createIndexName((String)connectorId), null);
    }
}

