/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.github;

import com.teamscale.core.authenticate.github.GitHubAppUtils;
import com.teamscale.core.authenticate.github.GitHubApplicationDescription;
import com.teamscale.core.authenticate.github.client.GitHubAppClient;
import com.teamscale.core.authenticate.index.AccessTokenIndex;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.service.base.ApiBase;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public abstract class GitHubServiceBase
extends ApiBase {
    protected GitHubAppClient getGithubAppClient(String appId) throws StorageException {
        Optional<GitHubApplicationDescription> applicationDescription = this.getGitHubApplicationDescriptions().stream().filter(gitHubApplicationDescription -> gitHubApplicationDescription.appId.equals(appId)).findFirst();
        if (applicationDescription.isEmpty()) {
            throw new StorageException("No GitHub application for " + appId + " installed.");
        }
        AccessTokenIndex accessTokenIndex = this.openGlobalIndex(AccessTokenIndex.class);
        return new GitHubAppClient(applicationDescription.get(), accessTokenIndex, this.getLogger());
    }

    protected List<GitHubApplicationDescription> getGitHubApplicationDescriptions() throws StorageException {
        ServerOptionIndex optionIndex = this.openGlobalIndex(ServerOptionIndex.class);
        return GitHubAppUtils.loadAllConfiguredApplications((ServerOptionIndex)optionIndex);
    }

    protected List<GitHubApplicationDescription> getValidGitHubApplicationDescriptions() throws StorageException {
        return CollectionUtils.filter(this.getGitHubApplicationDescriptions(), description -> description.validateApplication().isEmpty());
    }

    protected abstract Logger getLogger();
}

