/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.issues;

import com.teamscale.core.migration.ETeamscaleVersion;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.query.StoredQueryDescriptor;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.versioning.PublicApi;
import com.teamscale.service.query.StoredQueriesServiceBase;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/issues/queries")
public class IssueQueriesService
extends StoredQueriesServiceBase {
    public IssueQueriesService() {
        super(StoredQueryIndex.EStoredQueryType.ISSUE);
    }

    @GET
    @Operation(summary="Get issue queries", description="Retrieves the list of available issue query descriptors.", tags={"Issues", "Stored Queries"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<StoredQueryDescriptor> getIssueQueries() throws StorageException {
        return this.getAllQueries();
    }

    @POST
    @PublicApi(since=ETeamscaleVersion.VERSION_7_4_0)
    @Operation(summary="Save issue query", description="Creates an issue query descriptor in the system.", tags={"Issues", "Stored Queries"})
    @RequiresProjectPermission(value={EProjectPermission.EDIT_ISSUE_QUERIES})
    public void saveIssueQueryDescriptor(@RequestBody(required=true) StoredQueryDescriptor issueQueryDescriptor) throws StorageException {
        this.storeQuery(issueQueryDescriptor);
    }

    @DELETE
    @Path(value="{issueQueryName}")
    @Operation(summary="Delete issue query", description="Deletes an issue query descriptor from the system.", tags={"Stored Queries", "Issues"}, responses={@ApiResponse(responseCode="404", description="Issue query with the given name could not be found.")})
    @RequiresProjectPermission(value={EProjectPermission.EDIT_ISSUE_QUERIES})
    public void deleteIssueQueryDescriptor(@Parameter(description="Name of the issue metric to delete") @PathParam(value="issueQueryName") String issueQueryName) throws StorageException {
        this.deleteQuery(issueQueryName);
    }
}

