/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.logs;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.log.AuditLogs;
import com.teamscale.core.log.DetailedLogEntryBase;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.ShortLogEntryBase;
import com.teamscale.core.log.service.DetailedServiceLog;
import com.teamscale.core.log.service.ShortCriticalEventServiceLog;
import com.teamscale.core.log.worker.DetailedWorkerLog;
import com.teamscale.core.log.worker.ShortCriticalEventWorkerLog;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.logging.LogFilteringParameters;
import com.teamscale.service.framework.logging.LogIndexesWrapper;
import com.teamscale.service.framework.logging.LogServiceUtils;
import com.teamscale.service.framework.logging.ProjectLogLevelFrequencies;
import com.teamscale.service.framework.logging.ShortLogResponse;
import com.teamscale.service.logs.IGlobalLogServiceApi;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

@Path(value="api/logs/critical-events")
public class CriticalEventsGlobalLogService
extends ApiBase
implements IGlobalLogServiceApi<ShortLogEntryBase, DetailedServiceLog> {
    static final String CRITICAL_EVENT_LOG_FILENAME = "CriticalEventTeamscaleLogExport";

    @Override
    @Operation(summary="Get all critical event logs", description="Returns a list of all critical event short logs.", tags={"Logging"}, operationId="getGlobalCriticalEventLogs")
    public ShortLogResponse<ShortLogEntryBase> getAllShortLogs(LogFilteringParameters logFilteringParameters) throws StorageException {
        return LogServiceUtils.getShortLogs((LogFilteringParameters)logFilteringParameters, CriticalEventsGlobalLogService.openEventLogIndexes(this.getIndexLayer()));
    }

    @Override
    @Operation(summary="Get critical event detail log", description="Returns the detailed critical event log entry for the given timestamp.", tags={"Logging"}, operationId="getGlobalCriticalEventLog")
    public DetailedServiceLog getDetailedLog(LogEntryIdentifier logEntryIdentifier) throws StorageException {
        return (DetailedServiceLog)LogServiceUtils.getDetailedLogEntry(CriticalEventsGlobalLogService.openEventServiceLogIndexes(this.getIndexLayer()), (LogEntryIdentifier)logEntryIdentifier);
    }

    @Override
    @Operation(summary="Get critical event log frequencies", description="Returns the frequencies of the various critical event log types (i.e. INFO/WARN/ERROR).", tags={"Logging"}, operationId="getGlobalCriticalEventLogFrequencies")
    public List<ProjectLogLevelFrequencies> getLogFrequencies() throws StorageException {
        List serviceLogFrequencies = LogServiceUtils.obtainFrequencies(CriticalEventsGlobalLogService.openEventServiceLogIndexes(this.getIndexLayer()));
        List workerLogFrequencies = LogServiceUtils.obtainFrequencies(CriticalEventsGlobalLogService.openEventWorkerLogIndexes(this.getIndexLayer()));
        ArrayList<ProjectLogLevelFrequencies> result = new ArrayList<ProjectLogLevelFrequencies>();
        for (int i = 0; i < serviceLogFrequencies.size(); ++i) {
            result.add(ProjectLogLevelFrequencies.merge((ProjectLogLevelFrequencies)((ProjectLogLevelFrequencies)serviceLogFrequencies.get(i)), (ProjectLogLevelFrequencies)((ProjectLogLevelFrequencies)workerLogFrequencies.get(i))));
        }
        return result;
    }

    @Override
    @Operation(summary="Download critical event logs", description="Returns a file download of all critical event logs.", tags={"Logging"}, operationId="downloadGlobalCriticalEventLogs")
    public Response downloadLog(@BeanParam LogFilteringParameters logFilteringParameters, int maxChars) throws StorageException {
        return LogServiceUtils.createLogDownload((String)CRITICAL_EVENT_LOG_FILENAME, (LogFilteringParameters)logFilteringParameters, (int)maxChars, CriticalEventsGlobalLogService.openEventLogIndexes(this.getIndexLayer()));
    }

    @Override
    @Operation(summary="Delete critical event logs", description="Deletes all log entries that match the applied filters.", tags={"Logging"}, operationId="deleteGlobalCriticalEventLogs")
    public void deleteLogEntries(LogFilteringParameters logFilteringParameters) throws StorageException {
        LogServiceUtils.deleteLogEntries((LogFilteringParameters)logFilteringParameters, CriticalEventsGlobalLogService.openEventLogIndexes(this.getIndexLayer()));
        AuditLogs.globalLogDeletion((String)"critical event logs");
    }

    private static LogIndexesWrapper<ShortCriticalEventServiceLog, DetailedServiceLog> openEventServiceLogIndexes(IndexLayer indexLayer) throws StorageException {
        return new LogIndexesWrapper(LogServiceUtils.getAllCriticalEventLogIndexes((IndexLayer)indexLayer));
    }

    private static LogIndexesWrapper<ShortCriticalEventWorkerLog, DetailedWorkerLog> openEventWorkerLogIndexes(IndexLayer indexLayer) throws StorageException {
        PairList allWorkerLogIndexes = LogServiceUtils.getAllCriticalWorkerLogIndexes((IndexLayer)indexLayer);
        return new LogIndexesWrapper(allWorkerLogIndexes);
    }

    public static <SHORT_LOG_ENTRY extends ShortLogEntryBase, DETAILED_LOG_ENTRY extends DetailedLogEntryBase> LogIndexesWrapper<SHORT_LOG_ENTRY, DETAILED_LOG_ENTRY> openEventLogIndexes(IndexLayer indexLayer) throws StorageException {
        LogIndexesWrapper<ShortCriticalEventServiceLog, DetailedServiceLog> serviceLogIndexes = CriticalEventsGlobalLogService.openEventServiceLogIndexes(indexLayer);
        LogIndexesWrapper<ShortCriticalEventWorkerLog, DetailedWorkerLog> workerLogIndexes = CriticalEventsGlobalLogService.openEventWorkerLogIndexes(indexLayer);
        PairList allProjectsAndIndexes = serviceLogIndexes.getAllProjectsAndIndexes();
        allProjectsAndIndexes.addAll(workerLogIndexes.getAllProjectsAndIndexes());
        return new LogIndexesWrapper(allProjectsAndIndexes);
    }
}

