/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.merge_request;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.findings.calculation.TokenElementChurnWithOriginInfo;
import com.teamscale.index.merge_request.MergeRequestUtils;
import com.teamscale.index.repository.MergeBaseInfo;
import com.teamscale.index.repository.RepositoryLogIndex;
import com.teamscale.service.commits.DirectedCommitDeltaServiceBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/merge-requests/affected-files")
public class MergeRequestAffectedFilesService
extends DirectedCommitDeltaServiceBase {
    @GET
    @Operation(summary="Get affected files for merge request", description="Provides the list of changed files for a given merge request.", tags={"Merge Requests"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<TokenElementChurnWithOriginInfo> getMergeRequestAffectedFiles(@Parameter(description="The source commit descriptor.", required=true) @QueryParam(value="source") UnresolvedCommitDescriptor unresolvedSourceCommit, @Parameter(description="The target commit descriptor.", required=true) @QueryParam(value="target") UnresolvedCommitDescriptor unresolvedTargetCommit, @Parameter(description="Key of a precomputed merge-base info object.") @QueryParam(value="merge-base-cache-key") String cacheKey) throws StorageException {
        CommitDescriptor sourceCommit = this.resolve(unresolvedSourceCommit);
        CommitDescriptor targetCommit = this.resolve(unresolvedTargetCommit);
        RepositoryLogIndex repositoryLogIndex = this.openProjectIndex(RepositoryLogIndex.class, null);
        MergeBaseInfo mergeBaseInfo = this.getMergeBaseInfo(sourceCommit, targetCommit, cacheKey);
        return MergeRequestUtils.getMergeRequestAffectedCodeFiles((MergeBaseInfo)mergeBaseInfo, (RepositoryLogIndex)repositoryLogIndex, (ProjectStorageSystem)this.getProjectStorageSystem());
    }
}

