/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.merge_request;

import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.user.UserAliasLookup;
import com.teamscale.service.commits.DirectedCommitDeltaServiceBase;
import com.teamscale.service.commits.ExtendedRepositoryLogEntry;
import com.teamscale.service.commits.LogEntryResolver;
import com.teamscale.service.commits.RepositoryLogFilter;
import com.teamscale.service.findings.RepositoryChurnServiceUtils;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Collection;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@Path(value="api/projects/{project}/merge-requests/repository-churn")
public class MergeRequestRepositoryChurnService
extends DirectedCommitDeltaServiceBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @Operation(summary="Get merge request repository churn", description="Retrieves the merge request repository churn.", tags={"Merge Requests"}, responses={@ApiResponse(responseCode="400", description="Could not find a common ancestor commit for source commit and target commit. Maybe the analyzed history is too short?")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<ExtendedRepositoryLogEntry> getMergeRequestRepositoryChurn(@Parameter(description="ID of the project which analyzes the merge request.") @PathParam(value="project") IProjectId projectId, @Parameter(description="Source commit descriptor.", required=true) @QueryParam(value="source") UnresolvedCommitDescriptor unresolvedSourceCommit, @Parameter(description="Target commit descriptor.", required=true) @QueryParam(value="target") UnresolvedCommitDescriptor unresolvedTargetCommit, @Parameter(description="Key of a precomputed merge-base info object.") @QueryParam(value="merge-base-cache-key") String cacheKey, @BeanParam RepositoryLogFilter repositoryLogFilter) throws StorageException {
        LOGGER.traceEntry("Getting repository churn for merge request from '{}' to '{}' on project '{}'.", new Supplier[]{() -> unresolvedSourceCommit, () -> unresolvedTargetCommit, () -> this.asPrintableProjectId(projectId)});
        CommitDescriptor sourceCommit = this.resolve(unresolvedSourceCommit);
        CommitDescriptor targetCommit = this.resolve(unresolvedTargetCommit);
        UserAliasLookup userAliasLookup = UserAliasLookup.createInstance((GlobalStorageSystem)this.getGlobalStorageSystem());
        repositoryLogFilter.setFilteringOptions(userAliasLookup);
        repositoryLogFilter.setPrivacyRelatedFilteringInfo(true, this.getGlobalStorageSystem(), this.getPermissions(), this.getUser());
        return (List)LOGGER.traceExit(RepositoryChurnServiceUtils.getRepositoryLogEntriesForCommits(repositoryLogFilter, CollectionUtils.map((Collection)this.getMergeBaseInfo(sourceCommit, targetCommit, cacheKey).getAncestorsOfSource(), ParentedCommitDescriptor::getCommit), this.getProjectStorageSystem(), LogEntryResolver.of(this.serviceInfo, userAliasLookup), LOGGER));
    }

    private String asPrintableProjectId(IProjectId projectId) {
        try {
            return this.getIndexLayer().resolveToPrimaryPublicProjectId(projectId).toString();
        }
        catch (StorageException e) {
            return "(unknown project)";
        }
    }
}

