/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.merge_request;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.permissions.roles.EGlobalPermission;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.merge_request.ExtendedMergeRequest;
import com.teamscale.index.merge_request.ExtendedMergeRequestsInfo;
import com.teamscale.index.merge_request.MergeRequest;
import com.teamscale.index.merge_request.MergeRequestDeltaIndex;
import com.teamscale.index.merge_request.MergeRequestIndex;
import com.teamscale.index.merge_request.critical_changes.MergeRequestCriticalChangeInfo;
import com.teamscale.index.merge_request.voting.VotingRecordIndex;
import com.teamscale.index.repository.MergeBaseInfo;
import com.teamscale.index.requirements_tracing.merge_request.ImpactedSpecItemsDelta;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.tracking.FindingChurnCount;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.findings.FindingChurnListDto;
import com.teamscale.service.findings.FindingChurnTruncationParameter;
import com.teamscale.service.framework.authorization.RequiresGlobalPermission;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.merge_request.MergeRequestFilterSortUtils;
import com.teamscale.service.merge_request.MergeRequestOptions;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CounterSet;
import org.jspecify.annotations.Nullable;

@Path(value="api/projects/{project}/merge-requests")
public class MergeRequestService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="List of merge requests, total number and existing status.", tags={"Merge Requests"})
    public ExtendedMergeRequestsInfo listMergeRequests(@BeanParam MergeRequestOptions mergeRequestOptions) throws StorageException, ExecutionException, InterruptedException {
        MergeRequestIndex mergeRequestIndex = this.openProjectIndex(MergeRequestIndex.class, null);
        VotingRecordIndex votingRecordIndex = this.openProjectIndex(VotingRecordIndex.class, null);
        MergeRequestDeltaIndex mergeRequestDeltaIndex = this.openProjectIndex(MergeRequestDeltaIndex.class, null);
        List extendedMergeRequests = (List)this.getParallelTaskExecutor().computeInParallel((Collection)mergeRequestIndex.getAllMergeRequests(), mr -> MergeRequestService.addVoteAndFindingsSummaryToMergeRequest(votingRecordIndex, mergeRequestDeltaIndex, mr), Collectors.toCollection(ArrayList::new));
        return MergeRequestFilterSortUtils.sortedFilteredMergeRequests(mergeRequestOptions, extendedMergeRequests);
    }

    @GET
    @Path(value="{idWithRepository}/delta")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get a merge request analysis delta", tags={"Merge Requests"})
    @ApiResponse(responseCode="204", description="Merge request delta for the merge request with the given ID is null.")
    public @Nullable MergeRequestDeltaDto getMergeRequestDelta(@PathParam(value="idWithRepository") MergeRequestIdentifier identifier, @BeanParam FindingChurnTruncationParameter truncationParameter) throws StorageException {
        MergeRequestDeltaIndex mergeRequestDeltaIndex = this.openProjectIndex(MergeRequestDeltaIndex.class, null);
        return mergeRequestDeltaIndex.getDelta(identifier).map(delta -> new MergeRequestDeltaDto(delta.mergeBase(), truncationParameter.truncated(FindingChurnListDto.of(delta.findingChurnList())), delta.numberOfPendingExclusions(), delta.impactedSpecItemsDelta(), (CounterSet<ETestGapState>)delta.testGapStates(), delta.criticalChangeInfo())).orElse(null);
    }

    @GET
    @Path(value="{idWithRepository}")
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get a single merge request", tags={"Merge Requests"})
    @ApiResponse(responseCode="204", description="Merge request with the given ID does not exist.")
    public @Nullable ExtendedMergeRequest getMergeRequest(@PathParam(value="idWithRepository") MergeRequestIdentifier identifier) throws StorageException {
        MergeRequestIndex mergeRequestIndex = this.openProjectIndex(MergeRequestIndex.class, null);
        Optional mergeRequest = mergeRequestIndex.getMergeRequest(identifier);
        if (mergeRequest.isEmpty()) {
            return null;
        }
        VotingRecordIndex votingRecordIndex = this.openProjectIndex(VotingRecordIndex.class, null);
        MergeRequestDeltaIndex mergeRequestDeltaIndex = this.openProjectIndex(MergeRequestDeltaIndex.class, null);
        return MergeRequestService.addVoteAndFindingsSummaryToMergeRequest(votingRecordIndex, mergeRequestDeltaIndex, (MergeRequest)mergeRequest.get());
    }

    @DELETE
    @Hidden
    @Path(value="clear-index-without-polling-timestamps}")
    @RequiresGlobalPermission(value={EGlobalPermission.ACCESS_ADMINISTRATIVE_SERVICES})
    public void clearMergeRequestIndexWithoutResettingPollingTimestamps() throws StorageException {
        MergeRequestIndex mergeRequestIndex = this.openProjectIndex(MergeRequestIndex.class, null);
        mergeRequestIndex.clearIndexExceptLastPollTimestamp();
    }

    private static ExtendedMergeRequest addVoteAndFindingsSummaryToMergeRequest(VotingRecordIndex votingRecordIndex, MergeRequestDeltaIndex mergeRequestDeltaIndex, MergeRequest mergeRequest) throws StorageException {
        return new ExtendedMergeRequest(mergeRequest, votingRecordIndex.getNewestRecordForBranch(mergeRequest.getSourceBranch()), (FindingChurnCount)mergeRequestDeltaIndex.getDelta(mergeRequest.identifier).map(t -> new FindingChurnCount(t.findingChurnList())).orElse(null));
    }

    public record MergeRequestDeltaDto(@JsonProperty(value="mergeBase") @Nullable MergeBaseInfo mergeBase, @JsonProperty(value="findingChurnList") FindingChurnListDto findingChurnList, @JsonProperty(value="numberOfPendingExclusions") int numberOfPendingExclusions, @JsonProperty(value="impactedSpecItemsDelta") ImpactedSpecItemsDelta impactedSpecItemsDelta, @JsonProperty(value="testGapStates") @Nullable CounterSet<ETestGapState> testGapStates, @JsonProperty(value="criticalChangeInfo") @Nullable MergeRequestCriticalChangeInfo criticalChangeInfo) implements Serializable
    {
        private static final long serialVersionUID = 1L;
    }
}

