/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.resource.ContainerIndex;
import com.teamscale.index.resource.ResourceServiceUtils;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.Cache;
import com.teamscale.service.framework.cache.ReadCacheEnabled;
import com.teamscale.service.framework.cache.etag.AnalysisStateContributor;
import com.teamscale.service.framework.cache.etag.RequestContributor;
import com.teamscale.service.issues.IssueContributor;
import com.teamscale.service.requirements_tracing.SpecItemContributor;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPath;

@ReadCacheEnabled
@Cache(maxAge=1, eTagContributors={AnalysisStateContributor.class, RequestContributor.class, IssueContributor.class, SpecItemContributor.class})
@Path(value="api/projects/{project}/metrics")
public class ResourceMetricService
extends ApiBase {
    @GET
    @Operation(summary="Get metric values", description="Retrieves the metric values for a resource", tags={"Metrics"}, responses={@ApiResponse(responseCode="404", description="Requested uniform path could not be found.")})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public MetricDirectoryEntry getDirectMetricDirectoryEntry(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Uniform path to retrieve the metric values for", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        IMetricRetrievalStrategy metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser(), (MetricSchemaRetrieverFactory)new MetricSchemaRetrieverFactory((ProjectStorageSystem)this.getProjectStorageSystem()));
        MetricDirectoryEntry entry = metricRetrievalStrategy.getMetricDirectoryEntry(uniformPath, historyAccessOption);
        if (entry == null) {
            MetricDirectoryEntry latestEntry = metricRetrievalStrategy.getMetricDirectoryEntry(uniformPath, this.readDefaultBranchHead());
            if (latestEntry == null) {
                throw new NotFoundException("Path not found: " + String.valueOf(uniformPath));
            }
            entry = ResourceServiceUtils.createEmptyMetricDirectoryEntry((UniformPath)uniformPath);
        }
        return entry;
    }

    @GET
    @Path(value="with-subtree")
    @Operation(summary="Get metric values", description="Retrieves all metric values of resources found in the sub-tree.", tags={"Metrics"})
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    public List<MetricDirectoryEntry> getMetricDirectoryEntryRecursive(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="Uniform path to retrieve the metric values for", required=true, allowEmptyValue=true) @QueryParam(value="uniform-path") UniformPath uniformPath) throws StorageException {
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        ContainerIndex containerIndex = this.openProjectIndex(ContainerIndex.class, "container", historyAccessOption);
        String path = ResourceServiceUtils.getUniformPathPrefixContainerAware((ContainerIndex)containerIndex, (String)uniformPath.toString());
        List entries = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser(), (MetricSchemaRetrieverFactory)new MetricSchemaRetrieverFactory((ProjectStorageSystem)this.getProjectStorageSystem())).getMetricDirectoryEntries(List.of(path), historyAccessOption);
        if (entries.isEmpty()) {
            return Collections.emptyList();
        }
        this.adjustSchemaInEntries(entries, uniformPath);
        return entries;
    }

    private void adjustSchemaInEntries(List<MetricDirectoryEntry> entries, UniformPath uniformPath) throws StorageException {
        MetricDirectorySchema schema = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser(), (MetricSchemaRetrieverFactory)new MetricSchemaRetrieverFactory((ProjectStorageSystem)this.getProjectStorageSystem())).getMetricDirectorySchema();
        for (MetricDirectoryEntry entry : entries) {
            ResourceServiceUtils.adjustSchemaEntries((MetricDirectorySchema)schema, (MetricDirectoryEntry)entry);
        }
    }
}

