/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.badge;

import com.teamscale.service.badge.StaticBadgeUtils;
import com.teamscale.service.framework.badge.BadgeBuilder;
import com.teamscale.service.framework.badge.SegmentBuilder;
import com.teamscale.service.framework.badge.SegmentStyle;
import com.teamscale.service.framework.badge.sections.EBadgeIcon;
import java.util.Optional;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.string.StringUtils;

public class MergeRequestMetricBadgeCreator {
    private final String metricName;
    private final ETrafficLightColor assessmentColor;
    private final String metricResult;
    private final String incompleteBuildText;
    private static final int MARGIN = 5;

    public MergeRequestMetricBadgeCreator(String metricName, String metricResult, ETrafficLightColor assessmentColor, String incompleteBuildText) {
        this.metricName = metricName;
        this.assessmentColor = assessmentColor;
        this.metricResult = metricResult;
        this.incompleteBuildText = incompleteBuildText;
    }

    public byte[] createBadge() {
        BadgeBuilder badgeBuilder = new BadgeBuilder();
        StaticBadgeUtils.appendBuildJobsSegment(badgeBuilder, this.incompleteBuildText);
        badgeBuilder.textSegment(this.metricName).style(SegmentStyle.TITLE).append();
        if (StringUtils.isEmpty((String)this.metricResult)) {
            badgeBuilder.textSegment("unknown").style(SegmentStyle.GRAY).append();
            return StringUtils.stringToBytes((String)badgeBuilder.toSvg());
        }
        SegmentBuilder metricSegmentBuilder = badgeBuilder.segment().style(SegmentStyle.fromTrafficLightColor((ETrafficLightColor)this.assessmentColor)).air(5.0);
        Optional<EBadgeIcon> icon = MergeRequestMetricBadgeCreator.iconFromTrafficLightColor(this.assessmentColor);
        if (icon.isPresent()) {
            metricSegmentBuilder.icon(icon.get());
            metricSegmentBuilder.air(5.0);
        }
        metricSegmentBuilder.text(this.metricResult).air(5.0).append();
        return StringUtils.stringToBytes((String)badgeBuilder.toSvg());
    }

    private static Optional<EBadgeIcon> iconFromTrafficLightColor(ETrafficLightColor color) {
        return switch (color) {
            case ETrafficLightColor.RED -> Optional.of(EBadgeIcon.ROUND_MINUS_SIGN);
            case ETrafficLightColor.ORANGE, ETrafficLightColor.YELLOW -> Optional.of(EBadgeIcon.RISK_SIGN);
            case ETrafficLightColor.GREEN -> Optional.of(EBadgeIcon.ROUND_CHECK_SIGN);
            default -> Optional.empty();
        };
    }
}

