/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.badge;

import com.teamscale.service.badge.MetricGroupBadgeQueryParams;
import com.teamscale.service.badge.StaticBadgeUtils;
import com.teamscale.service.framework.badge.BadgeBuilder;
import com.teamscale.service.framework.badge.SegmentStyle;
import com.teamscale.service.framework.badge.sections.EBadgeIcon;
import org.apache.commons.text.StringEscapeUtils;
import org.conqat.lib.commons.string.StringUtils;

public class MergeRequestMetricGroupBadgeCreator {
    private final String groupName;
    private final int metricsWithoutData;
    private final int deterioratedMetrics;
    private final int stableMetrics;
    private final int improvedMetrics;
    private final int newThresholdViolations;
    private final boolean increasingValuesIndicateImprovement;
    private final String incompleteBuildText;
    private static final int MARGIN = 5;

    public MergeRequestMetricGroupBadgeCreator(MetricGroupBadgeQueryParams queryParams) {
        this.groupName = queryParams.getMetricGroupName();
        this.metricsWithoutData = queryParams.getMetricsWithoutData();
        this.deterioratedMetrics = queryParams.getDeterioratedMetrics();
        this.stableMetrics = queryParams.getStableMetrics();
        this.improvedMetrics = queryParams.getImprovedMetrics();
        this.newThresholdViolations = queryParams.getNewThresholdViolations();
        this.increasingValuesIndicateImprovement = queryParams.isIncreasingValuesIndicateImprovement();
        this.incompleteBuildText = queryParams.getIncompleteBuildText();
    }

    public byte[] createBadge() {
        BadgeBuilder badgeBuilder = new BadgeBuilder();
        StaticBadgeUtils.appendBuildJobsSegment(badgeBuilder, this.incompleteBuildText);
        badgeBuilder.textSegment(StringEscapeUtils.escapeXml11((String)this.groupName)).style(SegmentStyle.TITLE).append();
        if (this.metricsWithoutData > 0) {
            this.appendSegmentForMetricsWithoutData(badgeBuilder, String.valueOf(this.metricsWithoutData));
        }
        if (this.deterioratedMetrics > 0) {
            this.appendSegmentForDeterioratedMetrics(badgeBuilder, String.valueOf(this.deterioratedMetrics));
        }
        if (this.stableMetrics > 0) {
            this.appendSegmentForStableMetrics(badgeBuilder, String.valueOf(this.stableMetrics));
        }
        if (this.improvedMetrics > 0) {
            this.appendSegmentForImprovedMetrics(badgeBuilder, String.valueOf(this.improvedMetrics));
        }
        if (this.newThresholdViolations > 0) {
            this.appendSegmentForThresholdViolations(badgeBuilder, String.valueOf(this.newThresholdViolations));
        }
        return StringUtils.stringToBytes((String)badgeBuilder.toSvg());
    }

    private void appendSegmentForMetricsWithoutData(BadgeBuilder badgeBuilder, String text) {
        badgeBuilder.iconTextSegment(EBadgeIcon.ROUND_QUESTION_SIGN, text, 5).style(SegmentStyle.GRAY).tooltip("metrics without data: " + text).append();
    }

    private void appendSegmentForDeterioratedMetrics(BadgeBuilder badgeBuilder, String text) {
        EBadgeIcon icon = this.increasingValuesIndicateImprovement ? EBadgeIcon.SQUARE_CARET_DOWN : EBadgeIcon.SQUARE_CARET_UP;
        badgeBuilder.iconTextSegment(icon, text, 5).style(SegmentStyle.RED).tooltip("deteriorated metrics: " + text).append();
    }

    private void appendSegmentForStableMetrics(BadgeBuilder badgeBuilder, String text) {
        badgeBuilder.iconTextSegment(EBadgeIcon.SQUARE_CARET_LEFT, text, 5).style(SegmentStyle.BLUE).tooltip("stable metrics: " + text).append();
    }

    private void appendSegmentForImprovedMetrics(BadgeBuilder badgeBuilder, String text) {
        EBadgeIcon icon = this.increasingValuesIndicateImprovement ? EBadgeIcon.SQUARE_CARET_UP : EBadgeIcon.SQUARE_CARET_DOWN;
        badgeBuilder.iconTextSegment(icon, text, 5).style(SegmentStyle.GREEN).tooltip("improved metrics: " + text).append();
    }

    private void appendSegmentForThresholdViolations(BadgeBuilder badgeBuilder, String text) {
        badgeBuilder.iconTextSegment(EBadgeIcon.BELL, text, 5).style(SegmentStyle.ORANGE).tooltip("new threshold violations: " + text).append();
    }
}

