/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.distribution;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.service.metrics.distribution.MetricDistributionEntry;
import java.util.ArrayList;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.math.Range;

public class MetricDistributionDelta {
    @JsonProperty(value="range")
    private final Range range;
    @JsonProperty(value="deltas")
    private final ArrayList<Double> deltas;

    private MetricDistributionDelta(Range range, ArrayList<Double> deltas) {
        this.range = range;
        this.deltas = deltas;
    }

    public Range getRange() {
        return this.range;
    }

    public UnmodifiableList<Double> getDeltas() {
        return CollectionUtils.asUnmodifiable(this.deltas);
    }

    public static MetricDistributionDelta createDeltaFor(MetricDistributionEntry startEntry, MetricDistributionEntry endEntry) {
        CCSMAssert.isNotNull((Object)startEntry);
        CCSMAssert.isNotNull((Object)endEntry);
        UnmodifiableList<Double> startValues = startEntry.getValues();
        UnmodifiableList<Double> endValues = endEntry.getValues();
        CCSMAssert.isTrue((startValues.size() == endValues.size() ? 1 : 0) != 0, (String)"Both entries must have the same number of values.");
        boolean coversSimilarRange = startEntry.getRange().contains(endEntry.getRange()) || endEntry.getRange().contains(startEntry.getRange());
        CCSMAssert.isTrue((boolean)coversSimilarRange, (String)"Both entries must cover the same range.");
        Range newRange = startEntry.getRange().union(endEntry.getRange());
        ArrayList<Double> deltas = new ArrayList<Double>();
        for (int i = 0; i < startValues.size(); ++i) {
            deltas.add((Double)endValues.get(i) - (Double)startValues.get(i));
        }
        return new MetricDistributionDelta(newRange, deltas);
    }
}

