/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.scatterplot;

import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.core.user.User;
import com.teamscale.index.metrics.MetricNames;
import com.teamscale.index.resource.retrieval_strategy.IMetricRetrievalStrategy;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.cache.ReadCacheEnabled;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@ReadCacheEnabled
@Path(value="api/projects/{project}/metrics-scatter-plot")
public class MetricsScatterPlotService
extends ApiBase {
    private static final String METRIC_INDICES_PARAMETER = "metric-indices";
    private static final String METRIC_INDICES_DESCRIPTION = "The indices of the metrics used for the scatter plot.";
    private static final String UNIFORM_PATH_PARAMETER = "uniform-path";
    private static final String UNIFORM_PATH_DESCRIPTION = "For all files in the uniform path the metric are retrieved";

    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Get metric scatter plot", description="Retrieves a list of metrics for all files in the given path.", tags={"Metrics"})
    public List<MetricDirectoryEntry> getScatterPlotMetrics(@Parameter(description="This parameter can be used to pass a timestamp giving the time (in milliseconds since 1970) for which the data should be provided. This can optionally be prefixed by the name of the branch, followed by a colon.") @QueryParam(value="t") UnresolvedCommitDescriptor commit, @Parameter(description="The indices of the metrics used for the scatter plot.") @QueryParam(value="metric-indices") List<Integer> metricIndices, @Parameter(description="For all files in the uniform path the metric are retrieved") @DefaultValue(value="") @QueryParam(value="uniform-path") UniformPath uniformPath) throws StorageException {
        IMetricRetrievalStrategy metricRetrievalStrategy = MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), (ProjectStorageSystem)this.getProjectStorageSystem(), (GlobalStorageSystem)this.getGlobalStorageSystem(), (User)this.getUser());
        MetricDirectorySchema schema = metricRetrievalStrategy.getMetricDirectorySchema(HistoryAccessOption.readHeadUnbranched());
        int valueCountMetricIndex = MetricsScatterPlotService.getValueCountMetricIndex(schema);
        if (valueCountMetricIndex == -1) {
            return Collections.emptyList();
        }
        HistoryAccessOption historyAccessOption = this.determineHistoryOption(commit);
        List entries = metricRetrievalStrategy.getMetricDirectoryEntries(List.of(uniformPath.toString()), historyAccessOption);
        ArrayList<MetricDirectoryEntry> resultEntries = new ArrayList<MetricDirectoryEntry>();
        for (MetricDirectoryEntry entry : entries) {
            if (!MetricsScatterPlotService.isEntryCompatible(valueCountMetricIndex, entry)) continue;
            MetricDirectoryEntry metricDirectoryEntry = new MetricDirectoryEntry(entry.getUniformPath(), metricIndices.size());
            int index = 0;
            for (int metricIndex : metricIndices) {
                metricDirectoryEntry.setValue(index, entry.getValueOrDefault(metricIndex, null));
                ++index;
            }
            resultEntries.add(metricDirectoryEntry);
        }
        Collections.sort(resultEntries);
        return resultEntries;
    }

    private static boolean isEntryCompatible(int valueCountMetricIndex, MetricDirectoryEntry entry) {
        Object numberOfValues = entry.getValueWithoutNullAssert(valueCountMetricIndex);
        if (numberOfValues == null) {
            return false;
        }
        UniformPath entryUniformPath = UniformPathCompatibilityUtil.convert((String)entry.getUniformPath());
        return (Double)numberOfValues == 1.0 && !entry.hasChildren() || entryUniformPath.isSpecItemQueryPath() || entryUniformPath.isIssueQueryPath() || entryUniformPath.isTestQueryPath();
    }

    private static int getValueCountMetricIndex(MetricDirectorySchema schema) {
        int valueCountMetricIndex = -1;
        for (String firstMetricName : MetricNames.FIRST_METRIC_NAMES) {
            if (valueCountMetricIndex != -1) continue;
            valueCountMetricIndex = schema.getValuePosition(firstMetricName);
        }
        return valueCountMetricIndex;
    }
}

