/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.schema;

import com.teamscale.core.analysis.configuration.ConfigRegistry;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisGroup;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.QualityIndicator;
import com.teamscale.core.analysis.configuration.model.AnalysisGroupDescriptor;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.runtime.impl.analysis.trigger.TriggerCompilationException;
import com.teamscale.core.user.User;
import com.teamscale.index.configuration.ProjectValidationUtils;
import com.teamscale.index.resource.retrieval_strategy.MetricRetrievalStrategyFactory;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresNoPermission;
import com.teamscale.service.metrics.schema.ComposedMetricDirectorySchema;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@Path(value="api/metric-schema")
public class GlobalMetricSchemaService
extends ApiBase {
    private static final Logger LOGGER = LogManager.getLogger();

    @GET
    @RequiresNoPermission(description="Global metric directory schema is available to each authenticated user.")
    @Operation(summary="Get global metric schema", description="Retrieves all available metric schemas in the same order as the provided paths.", tags={"Metrics"})
    public List<MetricDirectorySchema> getGlobalMetricDirectorySchemas(@Parameter(description="List of uniform paths to retrieve metric directory schemas for") @DefaultValue(value="") @QueryParam(value="uniform-path") List<UniformPath> uniformPaths) throws StorageException {
        List allAnalysisProfiles = this.openGlobalIndex(AnalysisProfileIndex.class).getAllProfiles();
        return GlobalMetricSchemaService.getMergedMetricDirectorySchemas(this.getGlobalStorageSystem(), this.getUser(), allAnalysisProfiles, uniformPaths);
    }

    public static List<MetricDirectorySchema> getMergedMetricDirectorySchemas(GlobalStorageSystem globalStorageSystem, User user, List<AnalysisProfile> allAnalysisProfiles, List<UniformPath> uniformPaths) {
        ArrayList composedMetricDirectorySchemas = CollectionUtils.repeat(i -> new ComposedMetricDirectorySchema(), (int)uniformPaths.size());
        for (AnalysisProfile analysisProfile : allAnalysisProfiles) {
            try {
                AnalysisProfile reducedProfile = GlobalMetricSchemaService.getReducedAnalysisProfile(analysisProfile, globalStorageSystem);
                ProjectStorageSystem dummyProject = GlobalMetricSchemaService.createDummyProject(reducedProfile, globalStorageSystem);
                MetricSchemaRetrieverFactory schemaRetrieverFactory = new MetricSchemaRetrieverFactory(dummyProject);
                for (int i2 = 0; i2 < uniformPaths.size(); ++i2) {
                    UniformPath uniformPath = UniformPathCompatibilityUtil.convert((String)uniformPaths.get(i2).toString());
                    ((ComposedMetricDirectorySchema)composedMetricDirectorySchemas.get(i2)).add(MetricRetrievalStrategyFactory.getStrategy((UniformPath.EType)uniformPath.getType(), (ProjectStorageSystem)dummyProject, (GlobalStorageSystem)globalStorageSystem, (User)user, (MetricSchemaRetrieverFactory)schemaRetrieverFactory).getMetricDirectorySchema());
                }
            }
            catch (ProjectConfigurationException | TriggerCompilationException | IOException | StorageException e) {
                LOGGER.error("Error when creating dummy project for profile " + analysisProfile.getName(), e);
            }
        }
        return CollectionUtils.map((Collection)composedMetricDirectorySchemas, ComposedMetricDirectorySchema::getMergedResult);
    }

    private static AnalysisProfile getReducedAnalysisProfile(AnalysisProfile analysisProfile, GlobalStorageSystem storageSystem) throws ProjectConfigurationException, StorageException {
        Set externalTools = analysisProfile.getTools().stream().filter(tool -> !tool.isInternal() || tool == EAnalysisTool.TEAMSCALE).collect(Collectors.toSet());
        ConfigurationTemplate reducedTemplate = ConfigRegistry.getInstance().createConfigurationTemplate((Set)analysisProfile.getLanguages(), externalTools, storageSystem);
        AnalysisProfile reducedProfile = new AnalysisProfile(analysisProfile.getName(), (Set)analysisProfile.getLanguages(), externalTools);
        for (QualityIndicator qualityIndicator : analysisProfile.getQualityIndicators()) {
            reducedProfile.addQualityIndicator(qualityIndicator);
            ArrayList<AnalysisGroup> analysisGroupsToRemove = new ArrayList<AnalysisGroup>();
            for (AnalysisGroup analysisGroup : qualityIndicator.getGroups()) {
                GlobalMetricSchemaService.reduceAnalysisGroup(reducedTemplate, analysisGroupsToRemove, analysisGroup);
            }
            for (AnalysisGroup analysisGroup : analysisGroupsToRemove) {
                qualityIndicator.removeGroup(analysisGroup);
            }
        }
        return reducedProfile;
    }

    private static void reduceAnalysisGroup(ConfigurationTemplate reducedTemplate, List<AnalysisGroup> analysisGroupsToRemove, AnalysisGroup analysisGroup) {
        AnalysisGroupDescriptor analysisGroupDescriptor = reducedTemplate.getAnalysisGroup(analysisGroup.getName());
        if (analysisGroupDescriptor == null) {
            analysisGroupsToRemove.add(analysisGroup);
        } else {
            HashSet<String> optionsToRemove = new HashSet<String>();
            for (String option : analysisGroup.getOptionNames()) {
                if (analysisGroupDescriptor.getConfigurationItem(option) != null) continue;
                optionsToRemove.add(option);
            }
            analysisGroup.removeOptions(optionsToRemove);
        }
    }

    public static ProjectStorageSystem createDummyProject(AnalysisProfile analysisProfile, GlobalStorageSystem globalStorageSystem) throws StorageException, TriggerCompilationException, ProjectConfigurationException, IOException {
        IndexLayer dummyIndexLayer = ProjectValidationUtils.createDummyProject(List.of(analysisProfile), null, (GlobalStorageSystem)globalStorageSystem, (boolean)false);
        return ProjectValidationUtils.getDummyProjectPartition((IndexLayer)dummyIndexLayer);
    }
}

