/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.table;

import com.google.common.collect.Iterables;
import com.teamscale.core.analysis.configuration.index.model.EvaluatedMetricThreshold;
import com.teamscale.core.analysis.configuration.index.model.MetricThreshold;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfiguration;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.MetricThresholdIdentifier;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.metrics.directory.MetricDirectoryEntry;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchema;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.schema.MetricSchemaRetrieverFactory;
import com.teamscale.core.metrics.values.IMetricValue;
import com.teamscale.core.metrics.values.MetricValueBase;
import com.teamscale.index.merge_request.MetricAssessmentComputation;
import com.teamscale.index.metrics.assessment.ETrend;
import com.teamscale.index.metrics.assessment.MetricAssessment;
import com.teamscale.index.metrics.assessment.TrendDelta;
import com.teamscale.index.metrics.threshold.MetricThresholdSelectionUtils;
import com.teamscale.index.resource.ContainerInfo;
import com.teamscale.index.resource.EExtendedResourceType;
import com.teamscale.index.resource.ExtendedResourceTypeIndex;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import com.teamscale.index.resource.metrics.code_scopes.CodeScopesMetricsUtils;
import com.teamscale.index.resource.resolution_strategy.IResourceResolutionStrategy;
import com.teamscale.index.resource.resolution_strategy.ResourceResolutionStrategyFactory;
import com.teamscale.index.resource.utils.EResourceType;
import com.teamscale.index.thresholds.ProjectThresholdConfigurationUtils;
import com.teamscale.service.metrics.table.RootedList;
import com.teamscale.service.metrics.table.SinglePathDescriptor;
import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Lists;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class MetricTableServiceUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static RootedList<SinglePathDescriptor> collectAllSubPaths(UniformPath uniformRootPath, HistoryAccessOption historyAccess, ProjectStorageSystem storageSystem) throws StorageException {
        String rootPath = uniformRootPath.toString();
        IResourceResolutionStrategy resourceResolutionStrategy = ResourceResolutionStrategyFactory.getStrategy((UniformPath)uniformRootPath, (ProjectStorageSystem)storageSystem);
        SinglePathDescriptor rootPathDescriptor = new SinglePathDescriptor(rootPath, "", resourceResolutionStrategy.getResourceTypeForPath(uniformRootPath, historyAccess));
        List<SinglePathDescriptor> childPathDescriptors = new ArrayList<SinglePathDescriptor>();
        ContainerInfo rootInfo = resourceResolutionStrategy.getContainerInfoForPath(uniformRootPath, historyAccess);
        if (rootInfo != null) {
            childPathDescriptors.addAll(MetricTableServiceUtils.collectChildPaths(rootPath, resourceResolutionStrategy, rootInfo, historyAccess));
        }
        MetricTableServiceUtils.updateContentExcludes(historyAccess, storageSystem, Iterables.concat(Collections.singletonList(rootPathDescriptor), childPathDescriptors));
        if (StringUtils.isEmpty((String)rootPath)) {
            childPathDescriptors = childPathDescriptors.stream().filter(pathDescriptor -> !ArchitectureMetricsUtils.isArchitectureArtifactPath((String)pathDescriptor.getUniformPath()) && !CodeScopesMetricsUtils.isCodeScopesPath((String)pathDescriptor.getUniformPath())).collect(Collectors.toList());
        }
        return new RootedList<SinglePathDescriptor>(rootPathDescriptor, new ArrayList(), childPathDescriptors);
    }

    private static void updateContentExcludes(HistoryAccessOption historyAccess, ProjectStorageSystem storageSystem, Iterable<SinglePathDescriptor> result) throws StorageException {
        ArrayList uniformPaths = Lists.newArrayList(Iterables.transform(result, SinglePathDescriptor::getUniformPath).iterator());
        List<EnumSet<EExtendedResourceType>> additionalResourceInfos = MetricTableServiceUtils.getExtendedResourceInfos(storageSystem, uniformPaths, historyAccess);
        Iterator<SinglePathDescriptor> it = result.iterator();
        for (int i = 0; i < uniformPaths.size(); ++i) {
            boolean isContentExcluded = additionalResourceInfos.get(i) != null && additionalResourceInfos.get(i).contains(EExtendedResourceType.CONTENT_EXCLUDED);
            it.next().setIsContentExcluded(isContentExcluded);
        }
    }

    private static Collection<SinglePathDescriptor> collectChildPaths(String rootPath, IResourceResolutionStrategy resourceResolutionStrategy, ContainerInfo rootInfo, HistoryAccessOption historyAccessOption) throws StorageException {
        List childInfos = resourceResolutionStrategy.getContainerInfosForPaths(rootInfo.getChildren().stream().map(UniformPathCompatibilityUtil::convert).collect(Collectors.toList()), historyAccessOption);
        Map childInfoMap = childInfos.stream().filter(Objects::nonNull).collect(Collectors.toMap(ContainerInfo::getUniformPath, Function.identity()));
        Map<String, EResourceType> pathsAndResourceTypes = MetricTableServiceUtils.expandPathResourceTypes(rootPath, resourceResolutionStrategy, rootInfo, historyAccessOption, childInfos);
        return pathsAndResourceTypes.entrySet().stream().map(CollectionUtils.asSneakyFunction(pathAndResourceType -> MetricTableServiceUtils.createSinglePathDescriptor(rootPath, resourceResolutionStrategy, historyAccessOption, pathAndResourceType, (ContainerInfo)childInfoMap.get(pathAndResourceType.getKey())))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static Optional<SinglePathDescriptor> createSinglePathDescriptor(String rootPath, IResourceResolutionStrategy resourceResolutionStrategy, HistoryAccessOption historyAccessOption, Map.Entry<String, EResourceType> pathAndResourceType, ContainerInfo containerInfo) throws StorageException {
        if (!UniformPathUtils.isArchitectureRootComponent((String)pathAndResourceType.getKey()) && containerInfo != null && !containerInfo.getDeepestRelativePathWithMoreThanOneChild().isEmpty()) {
            String fullPath = containerInfo.getUniformPath() + UniformPathUtils.SEPARATOR + containerInfo.getDeepestRelativePathWithMoreThanOneChild();
            return MetricTableServiceUtils.buildPathDescriptor(rootPath, fullPath, resourceResolutionStrategy.getResourceTypeForPath(UniformPathCompatibilityUtil.convert((String)fullPath), historyAccessOption));
        }
        return MetricTableServiceUtils.buildPathDescriptor(rootPath, pathAndResourceType.getKey(), pathAndResourceType.getValue());
    }

    private static @NonNull Map<String, EResourceType> expandPathResourceTypes(String rootPath, IResourceResolutionStrategy resourceResolutionStrategy, ContainerInfo rootInfo, HistoryAccessOption historyAccessOption, List<ContainerInfo> childInfos) throws StorageException {
        Map<String, EResourceType> pathsAndResourceTypes = MetricTableServiceUtils.collectPathAndResourceTypes(rootPath, childInfos, resourceResolutionStrategy, rootInfo, historyAccessOption);
        pathsAndResourceTypes.putAll(resourceResolutionStrategy.getResourceChildTypesForPath(UniformPathCompatibilityUtil.convert((String)rootPath), false, historyAccessOption));
        return pathsAndResourceTypes;
    }

    private static Optional<SinglePathDescriptor> buildPathDescriptor(String rootPath, String fullPath, EResourceType resourceType) {
        boolean isDummyElementInEmptyComponent;
        boolean bl = isDummyElementInEmptyComponent = fullPath.equals(rootPath + UniformPathUtils.SEPARATOR) && rootPath.startsWith(UniformPath.EType.ARCHITECTURE.getPrefix()) && resourceType == EResourceType.FILE;
        if (isDummyElementInEmptyComponent) {
            return Optional.empty();
        }
        return Optional.of(new SinglePathDescriptor(rootPath, StringUtils.stripPrefix((String)fullPath, (String)(rootPath + UniformPathUtils.SEPARATOR)), resourceType));
    }

    private static Map<String, EResourceType> collectPathAndResourceTypes(String rootPath, List<ContainerInfo> childInfos, IResourceResolutionStrategy resourceResolutionStrategy, ContainerInfo rootInfo, HistoryAccessOption historyAccessOption) throws StorageException {
        ArrayList childPaths = new ArrayList(rootInfo.getChildren());
        Map childrenWithResourceType = rootInfo.getChildrenWithResourceType();
        HashMap<String, EResourceType> result = new HashMap<String, EResourceType>();
        for (int i = 0; i < childPaths.size(); ++i) {
            if (childInfos.get(i) != null) continue;
            result.put((String)childPaths.get(i), childrenWithResourceType.getOrDefault(childPaths.get(i), EResourceType.FILE));
        }
        result.putAll(resourceResolutionStrategy.getResourceChildTypesForPath(UniformPathCompatibilityUtil.convert((String)rootPath), false, historyAccessOption));
        return result;
    }

    private static List<EnumSet<EExtendedResourceType>> getExtendedResourceInfos(ProjectStorageSystem storageSystem, List<String> uniformPaths, HistoryAccessOption historyAccessOption) throws StorageException {
        ExtendedResourceTypeIndex extendedResourceIndex = (ExtendedResourceTypeIndex)storageSystem.openProjectIndex(ExtendedResourceTypeIndex.class, historyAccessOption);
        return extendedResourceIndex.getAllResourceTypes(uniformPaths);
    }

    public static MetricThresholdConfiguration loadThresholdConfiguration(String thresholdConfigurationName, IStorageInfo storageInfo, MetricSchemaRetrieverFactory schemaRetrieverFactory) throws StorageException {
        MetricThresholdConfiguration thresholdConfiguration = ProjectThresholdConfigurationUtils.getThresholdConfiguration((String)thresholdConfigurationName, (IStorageInfo)storageInfo, (MetricSchemaRetrieverFactory)schemaRetrieverFactory);
        if (thresholdConfiguration == null) {
            throw new NotFoundException("Threshold Configuration '" + thresholdConfigurationName + "' doesn't exist.");
        }
        return thresholdConfiguration;
    }

    public static MetricAssessment getDefaultMetricAssessment(String uniformPath, MetricDirectorySchema schema, String metricName, @Nullable MetricDirectoryEntry metricEntry) {
        boolean shouldBeHiddenForArchitectureSummary;
        int valuePosition = schema.getValuePosition(metricName);
        if (valuePosition == -1) {
            throw new NotFoundException("Metric \"" + metricName + "\" not known or configured for project.");
        }
        MetricDirectorySchemaEntry entry = schema.getEntry(valuePosition);
        Object value = null;
        boolean metricEntryAvailable = false;
        boolean bl = shouldBeHiddenForArchitectureSummary = uniformPath.equals("-architecture-files-") && !entry.hasProperty(EMetricProperty.ARCHITECTURE_RELEVANT);
        if (metricEntry != null && !shouldBeHiddenForArchitectureSummary) {
            value = metricEntry.getValueOrDefault(valuePosition, null);
            metricEntryAvailable = true;
        }
        return new MetricAssessment(entry, (IMetricValue)MetricValueBase.createWithRawValue((MetricDirectorySchemaEntry)entry, value), ETrafficLightColor.UNKNOWN, ETrafficLightColor.UNKNOWN, ETrend.NA, TrendDelta.NOT_AVAILABLE, new EvaluatedMetricThreshold(new MetricThreshold(metricName), Double.valueOf(0.0), Double.valueOf(0.0)), metricEntryAvailable);
    }

    public static Optional<MetricAssessment> getMetricAssessmentFromThresholdConfiguration(String uniformPath, HistoryAccessOption historyAccessOption, HistoryAccessOption historyAccessOptionBaseline, MetricThresholdConfiguration thresholdConfiguration, String metricName, MetricAssessmentComputation assessmentComputation) throws StorageException {
        try {
            Optional thresholdIdentifier = MetricThresholdSelectionUtils.findBestMatchingThresholdInConfiguration((MetricThresholdConfiguration)thresholdConfiguration, (String)metricName, (String)uniformPath);
            if (thresholdIdentifier.isEmpty()) {
                return Optional.empty();
            }
            return assessmentComputation.computeSingleAssessment(uniformPath, (MetricThresholdIdentifier)thresholdIdentifier.get(), historyAccessOption, historyAccessOptionBaseline);
        }
        catch (MetricThresholdConfigurationException e) {
            LOGGER.error("Error during search for best threshold: " + e.getMessage(), (Throwable)e);
        }
        catch (BadRequestException e) {
            LOGGER.error("Evaluation of threshold failed: " + e.getMessage(), (Throwable)e);
        }
        return Optional.empty();
    }

    public static List<Boolean> areTestCode(List<SinglePathDescriptor> pathDescriptors, ExtendedResourceTypeIndex resourceTypeIndex) throws StorageException {
        List<String> uniformPaths = pathDescriptors.stream().map(SinglePathDescriptor::getUniformPath).toList();
        return resourceTypeIndex.isTestCode(uniformPaths);
    }

    private MetricTableServiceUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

