/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.metrics.table;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.resource.utils.EResourceType;
import java.util.Collection;

public abstract class TableEntryBase<T> {
    protected static final String RELATIVE_PATH_PROPERTY = "relativePath";
    protected static final String METRICS_PROPERTY = "metrics";
    protected static final String RESOURCE_TYPE_PROPERTY = "resourceType";
    protected static final String IS_TEST_PROPERTY = "isTest";
    @JsonProperty(value="relativePath")
    public final String relativePath;
    @JsonProperty(value="isContentExcluded")
    boolean isContentExcluded;
    @JsonProperty(value="resourceType")
    private final EResourceType resourceType;
    @JsonProperty(value="isTest")
    protected boolean isTest = false;

    protected TableEntryBase(String relativePath, EResourceType resourceType) {
        this.relativePath = relativePath;
        this.resourceType = resourceType;
    }

    public void setIsContentExcluded(boolean wasExcluded) {
        this.isContentExcluded = wasExcluded;
    }

    public String toString() {
        return this.relativePath + " (" + this.resourceType.toString() + ") " + this.getMetrics().size() + " values";
    }

    protected abstract Collection<T> getMetrics();

    public EResourceType getResourceType() {
        return this.resourceType;
    }

    public String getRelativePath() {
        return this.relativePath;
    }
}

